

<?php $__env->startSection('title', "Demandes en attente d'examen"); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-5 my-5">
    <!-- List of applications awaiting review -->
    <div>
        <div>
            <div class="container my-4">
                <div style="border: 2px inset #007481; border-radius: 50px;"
                    class="my-4 p-3 bg-primary text-secondary text-center fw-bold text-uppercase">Liste des demandes en
                    attente d'examen</div>
            </div>
            <div id="table" class="container">
                <table class="table table-bordered table-striped table-hover dataTables">
                    <thead class="table-success">
                        <tr>
                            <th>N°</th>
                            <th>Titre Demande</th>
                            <th>Type Demande</th>
                            <th>Docuement(s) Joint(s)</th>
                            <th>Commentaire</th>
                            <th>Date Envoi</th>
                            <th>Staut Demande</th>
                            <th>Direction</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($demandes) && $demandes->count() > 0): ?>
                        <?php $__currentLoopData = $demandes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $demande): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(($key + 1)); ?></td>
                            <td><?php echo e($demande->titre_demande); ?></td>
                            <td><?php echo e($demande->typeDocument->libelle); ?></td>
                            <td>
                                <?php $attachments = $demande->documents_joints; ?>
                                <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="mb-3">
                                    <a target="_blank" href="<?php echo e(url('storage/documents_recus/'.$attachment)); ?>"
                                        title="Cliquer pour visualier ou télécharger">
                                        <?php echo e($attachment); ?>

                                    </a>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td><?php echo $demande->commentaire; ?></td>
                            <td><?php echo e(Utilities::formatDate($demande->date_demande)); ?></td>
                            <?php
                            $color = '';
                            if ($demande->id_statut_demande == 2){
                            $color = '#f2b707';
                            }
                            if ($demande->id_statut_demande == 3){
                            $color = '#0cc0e4';
                            }
                            if ($demande->id_statut_demande == 4){
                            $color = '#e443b1';
                            }
                            if ($demande->id_statut_demande == 5){
                            $color = '#dc3545';
                            }
                            if ($demande->id_statut_demande == 6){
                            $color = '#188050';
                            }
                            ?>
                            <td class="fw-bold" style="color: <?php echo e($color ?? '#444444'); ?>">
                                <?php echo e($demande->statutDemande->libelle); ?>

                            </td>
                            <td><?php echo e($demande->typeDocument->service->direction->nom); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\MAMADI CISSE\Documents\MCIPME\digit-mcipme\resources\views/frontend/pages/demandes/categories/review.blade.php ENDPATH**/ ?>