

<?php $__env->startSection('title', 'Demandes en attente de modification'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-5 my-5">
    <!-- List of requests awaiting modification -->
    <div>
        <div>
            <div class="container my-4">
                <div style="border: 2px inset #007481; border-radius: 50px;"
                    class="my-4 p-3 bg-primary text-secondary text-center fw-bold text-uppercase">Liste des demandes
                    en attente de modification</div>
            </div>
            <div id="table" class="container">
                <table class="table table-bordered table-striped table-hover dataTables">
                    <thead class="table-success">
                        <tr>
                            <th>N°</th>
                            <th>Titre Demande</th>
                            <th>Type Demande</th>
                            <th>Date Envoi</th>
                            <th>Direction</th>
                            <th>Staut Demande</th>
                            <th>Date Renvoi</th>
                            <th>Motif Renvoi</th>
                            <th>Document Transmis</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($demandes) && $demandes->count() > 0): ?>
                        <?php $__currentLoopData = $demandes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $demande_r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(($key + 1)); ?></td>
                            <td><?php echo e($demande_r->demande->titre_demande); ?></td>
                            <td><?php echo e($demande_r->demande->typeDocument->libelle); ?></td>
                            <td><?php echo e(Utilities::formatDate($demande_r->demande->date_demande)); ?></td>
                            <td><?php echo e($demande_r->demande->typeDocument->service->direction->nom); ?></td>
                            <?php
                            $color = '';
                            if ($demande_r->demande->id_statut_demande == 2){
                            $color = '#f2b707';
                            }
                            if ($demande_r->demande->id_statut_demande == 3){
                            $color = '#0cc0e4';
                            }
                            if ($demande_r->demande->id_statut_demande == 4){
                            $color = '#e443b1';
                            }
                            if ($demande_r->demande->id_statut_demande == 5){
                            $color = '#dc3545';
                            }
                            if ($demande_r->demande->id_statut_demande == 6){
                            $color = '#188050';
                            }
                            ?>
                            <td class="fw-bold" style="color: <?php echo e($color ?? '#444444'); ?>">
                                <?php echo e($demande_r->demande->statutDemande->libelle); ?>

                            </td>
                            <td><?php echo e(Utilities::formatDate($demande_r->date_renvoi)); ?></td>
                            <td class="text-center">
                                <?php if($demande_r->motif_renvoi != NULL): ?>
                                <a class="btn btn-info" href="#" data-bs-toggle="modal"
                                    data-bs-target="#modalRejectDetail-<?php echo e($demande_r->id_demande); ?>"
                                    title="Cliquer pour voir le détail">
                                    <i class="fa fa-eye"></i>
                                </a>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php $attachments = $demande_r->documents_joints; ?>
                                <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="mb-3">
                                    <a target="_blank" href="<?php echo e(url('storage/documents_recus/'.$attachment)); ?>"
                                        title="Cliquer pour visualier ou télécharger">
                                        <?php echo e($attachment); ?>

                                    </a>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td>
                                <?php if($demande_r->demande->id_statut_demande == 4): ?>
                                <a class="btn btn-warning"
                                    href="<?php echo e(route('dashboard.demande.edit', $demande_r->demande->id_demande)); ?>">Modifier</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <div class="modal fade" id="modalRejectDetail-<?php echo e($demande_r->id_demande); ?>" tabindex="-1"
                            aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="bg-primary modal-content">
                                    <div class="modal-header bg-secondary">
                                        <h1 class="modal-title fs-5 text-primary" id="staticBackdropLabel">Motif du renvoi</h1>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="p-4">
                                        <?php echo $demande_r->motif_renvoi; ?>

                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary"
                                            data-bs-dismiss="modal">Quitter</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\MAMADI CISSE\Documents\MCIPME\digit-mcipme\resources\views/frontend/pages/demandes/categories/modification.blade.php ENDPATH**/ ?>