<?php $__env->startSection('title', 'Liste des demandes'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid pt-4 px-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="text-center">
                <h3 class="bg-primary rounded p-3 mb-4">Liste des Demandes</h3>
            </div>
        </div>
        <div class="col-12">
            <div class="bg-secondary rounded h-100 p-4">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th>N°</th>
                                <th>Demandeur</th>
                                <th>Titre</th>
                                <th>Type Document</th>
                                <th>Fichier Joint</th>
                                <th>Commentaire</th>
                                <th>Date Envoi</th>
                                <th>Staut Demande</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(isset($demandes) && $demandes->count() > 0): ?>
                            <?php $__currentLoopData = $demandes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $demande): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(($key + 1)); ?></td>
                                <td><?php echo e($demande->promoteur->nom_entreprise); ?></td>
                                <td><?php echo e($demande->titre_demande); ?></td>
                                <td><?php echo e($demande->typeDocument->libelle); ?></td>
                                <td>
                                    <?php $attachments = $demande->documents_joints; ?>
                                    <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="mb-3">
                                        <a target="_blank" href="<?php echo e(url('storage/documents_recus/'.$attachment)); ?>"
                                            title="Cliquer pour visualier ou télécharger">
                                            <?php echo e($attachment); ?><br />
                                        </a>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td><?php echo $demande->commentaire; ?></td>
                                <td><?php echo e(Utilities::formatDate($demande->date_demande)); ?></td>
                                <?php
                                $color = '';
                                if ($demande->id_statut_demande == 2){
                                $color = '#f2b707';
                                }
                                if ($demande->id_statut_demande == 3){
                                $color = '#0cc0e4';
                                }
                                if ($demande->id_statut_demande == 4){
                                $color = '#ffffff';
                                }
                                if ($demande->id_statut_demande == 5){
                                $color = '#dc3545';
                                }
                                if ($demande->id_statut_demande == 6){
                                $color = '#188050';
                                }
                                ?>
                                <td class="fw-bold" style="color: <?php echo e($color ?? '#5c678d'); ?>">
                                    <?php echo e($demande->statutDemande->libelle); ?>

                                </td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <?php if (\Illuminate\Support\Facades\Blade::check('hasrole', 'ministre')): ?>
                                        <?php if($demande->id_statut_demande == 1): ?>
                                        <a class="btn btn-warning" href="#"
                                            onclick="orientDemande(<?php echo e($demande->id_demande); ?>)">Orienter</a>
                                        <a class="btn btn-danger" href="#" data-bs-toggle="modal"
                                            data-bs-target="#modalReject-<?php echo e($demande->id_demande); ?>">Rejeter</a>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                        <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', Admin::getDirectionRoles())): ?>
                                        <?php if($demande->id_statut_demande == 2): ?>
                                        <a class="btn btn-warning" href="#"
                                            onclick="orientDemande(<?php echo e($demande->id_demande); ?>)">Orienter</a>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                        <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', Admin::getServiceRoles())): ?>
                                        <?php if($demande->id_statut_demande == 3): ?>
                                        
                                        <a class="btn btn-info"
                                            href="<?php echo e(route('dashboard.demande.process', $demande->id_demande)); ?>">Traiter</a>
                                        <a class="btn btn-warning"
                                            href="<?php echo e(route('dashboard.demande.return', $demande->id_demande)); ?>">Renvoyer</a>
                                        
                                        <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <script>
                                function orientDemande(demande) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr de vouloir orienter cette demande ?",
                                                    // text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, orienter!",
                                                    cancelButtonText: "Annuler"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "<?php echo e(route('dashboard.demande.orient', ':demande')); ?>".replace(':demande', demande);
                                                    }
                                                });
                                            }

                                            function returnDemande(demande) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr de vouloir retourner cette demande ?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, orienter!",
                                                    cancelButtonText: "Annuler"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "<?php echo e(route('dashboard.demande.return', ':demande')); ?>".replace(':demande', demande);
                                                    }
                                                });
                                            }
                            </script>
                            <!-- Modal -->
                            <!-- Orient -->
                            
                            <!-- Reject -->
                            <div class="modal fade" id="modalReject-<?php echo e($demande->id_demande); ?>" data-bs-keyboard="false"
                                tabindex="-1" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="bg-secondary modal-content">
                                        <div class="modal-header">
                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Rejeter la demande
                                            </h1>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <form id="reject-form-<?php echo e($demande->id_demande); ?>"
                                            action="<?php echo e(route('dashboard.demande.reject', $demande->id_demande)); ?>"
                                            method="POST">
                                            <?php echo csrf_field(); ?>
                                            <div class="bg-secondary modal-body">
                                                <input type="hidden" name="demande" value="<?php echo e($demande->id_demande); ?>">
                                                <textarea class="form-control" name="motif" id="motif_rejet" rows="10"
                                                    cols="30" required
                                                    placeholder="Donnez le motif du rejet"></textarea>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">Quitter</button>
                                                <button type="submit" class="btn btn-primary">Rejeter</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <!-- Return -->
                            
                            <!-- ./Fin Modal -->
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr class="text-center">
                                <td colspan="11" class="fw-bold">Aucune donnée n'est disponible.</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\MAMADI CISSE\Documents\MCIPME\digit-mcipme\resources\views/backend/pages/demandes/list-of-demandes.blade.php ENDPATH**/ ?>