<?php

    if (auth()->check() && !auth()->user()->hasAnyRole(Admin::getAllImportantRoles())) {
    $promoteur = Auth::user()->promoteur->id_promoteur;
    # Liste de toutes les demandes
    $allDemandes = App\Models\Demande::where('id_promoteur', $promoteur)->get();
    # Liste des demandes en attente de traitement
    $awaitingProcessingDemandes = App\Models\Demande::where(['id_statut_demande' => 1, 'id_promoteur' =>
    $promoteur])->get();
    # Liste des demandes en attente d'étude
    $awaitingStudyDemandes = App\Models\Demande::where(['id_statut_demande' => 2, 'id_promoteur' => $promoteur])->get();
    # Liste des demandes en attente d'examen
    $awaitingReviewDemandes = App\Models\Demande::where(['id_statut_demande' => 3, 'id_promoteur' => $promoteur])->get();
    # Liste des demandes en attente de modification
    $awaitingModificationDemandes = App\Models\DemandeRenvoyee::with(['demande' => function ($query) use ($promoteur) {
        $query->where('id_statut_demande', 4)
                ->where('id_promoteur', $promoteur);
    }])
    ->get()
    ->filter(function ($demandeRenvoyee) {
        return $demandeRenvoyee->demande !== null;
    })
    ->unique('id_demande');
    # Liste des demandes rejetées
    $rejectedDemandes = App\Models\DemandeRejetee::select('demande_rejetees.*')
    ->join('demandes', 'demandes.id_demande', '=', 'demande_rejetees.id_demande')
    ->where('demandes.id_statut_demande', 5)
    ->where('demandes.id_promoteur', $promoteur)
    ->get();
    # Liste des demandes traitées
    $processedDemandes = App\Models\DemandeTraitee::select('demande_traitees.*')
    ->join('demandes', 'demandes.id_demande', '=', 'demande_traitees.id_demande')
    ->where('demandes.id_statut_demande', 6)
    ->where('demandes.id_promoteur', $promoteur)
    ->get();
    }
?>
<nav class="navbar navbar-expand-sm navbar-light fixed-top bg-primary">
    <div class="container">
        <a class="navbar-brand" href="<?php echo e(route('home')); ?>">
            <img id="logo-anime" src="<?php echo e(url('assets/images/logos/logo_plaged.png')); ?>" width="200" alt="">
        </a>
        <button class="navbar-toggler d-lg-none" type="button" data-bs-toggle="collapse"
            data-bs-target="#collapsibleNavId" aria-controls="collapsibleNavId" aria-expanded="false"
            aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="collapsibleNavId">
            <ul class="navbar-nav mx-auto mt-2 mt-lg-0">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Route::is('home') ? 'active' : ''); ?>" href="<?php echo e(route('home')); ?>"
                        aria-current="page">
                        Accueil
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Route::is('guide.to.procedures') ? 'active' : ''); ?>"
                        href="<?php echo e(route('guide.to.procedures')); ?>" aria-current="page">
                        Guide des démarches
                    </a>
                </li>
                <?php if(auth()->guard()->check()): ?>
                <?php if(!auth()->user()->hasAnyRole(Admin::getAllImportantRoles())): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Route::is('demande.add') ? 'active' : ''); ?>"
                        href="<?php echo e(route('demande.add')); ?>">
                        Faire une demande
                    </a>
                </li>
                <li class="nav-item">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo e(Route::is('demande.index') || Route::is('demande.category') ? 'active' : ''); ?>"
                        href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Mes demandes <span class="text-danger" style="position: relative; top: -5px; font-size: 14px;"><?php echo e($allDemandes->count() > 0 ? '('.$allDemandes->count().')' : ''); ?></span>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?php echo e(route('demande.index')); ?>">Toutes les demandes (<?php echo e($allDemandes->count()); ?>)</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('demande.category', 'processing')); ?>">En attente de
                                traitement (<?php echo e($awaitingProcessingDemandes->count()); ?>)</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('demande.category', 'study')); ?>">En attente d'étude
                                (<?php echo e($awaitingStudyDemandes->count()); ?>)</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('demande.category', 'review')); ?>">En attente
                                d'examnen (<?php echo e($awaitingReviewDemandes->count()); ?>)</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('demande.category', 'modification')); ?>">En attente
                                de motification (<?php echo e($awaitingModificationDemandes->count()); ?>)</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('demande.category', 'rejected')); ?>">Rejetées (<?php echo e($rejectedDemandes->count()); ?>)</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('demande.category', 'processed')); ?>">Traitées (<?php echo e($processedDemandes->count()); ?>)</a></li>
                    </ul>
                </li>
                
                <?php endif; ?>
                <?php if (\Illuminate\Support\Facades\Blade::check('hasanyrole', Admin::getAllImportantRoles())): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                </li>
                <?php endif; ?>
                <?php endif; ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(Route::is('contact.us') ? 'active' : ''); ?>" href="<?php echo e(route('contact.us')); ?>"
                        aria-current="page">
                        Contact
                    </a>
                </li>
            </ul>
            <?php if(auth()->guard()->check()): ?>
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
                    <img class="rounded-circle me-lg-2" src="<?php echo e(url('assets/images/profile-pictures/user.png')); ?>"
                        alt="" style="width: 40px; height: 40px;">
                    <span class="d-none d-lg-inline-flex"><?php echo e(auth()->user()->first_name); ?></span>
                </a>
                <div class="dropdown-menu border-0 rounded-0 rounded-bottom m-0">
                    <a href="#" class="dropdown-item px-2 nav-link text-dark text-center"
                        onclick="window.location.href = '/logout'">
                        Se déconnecter
                    </a>
                    
                </div>
            </div>
            <?php else: ?>
            <ul class="navbar-nav mr-auto mt-2 mt-lg-0">
                <?php if(!Route::is('login')): ?>
                <li class="nav-item">
                    <a class="btn btn-secondary me-2" href="<?php echo e(route('login')); ?>">
                        Se connecter
                    </a>
                </li>
                <?php endif; ?>
                <?php if(!Route::is('register')): ?>
                <li class="nav-item">
                    <a class="btn btn-secondary me-2" href="<?php echo e(route('register')); ?>">
                        S'inscrire
                    </a>
                </li>
                <?php endif; ?>
            </ul>
            <?php endif; ?>
        </div>
    </div>
</nav><?php /**PATH C:\Users\MAMADI CISSE\Documents\MCIPME\digit-mcipme\resources\views/frontend/layouts/inc/_navbar.blade.php ENDPATH**/ ?>