<?php $__env->startSection('content'); ?>
   <!-- Sale & Revenue Start -->
   <div class="container-fluid pt-4 px-4">
       <h2>Détails de la direction</h2>
       
       <!-- Champs de filtre et de recherche -->
       <div class="mb-4">
           <div class="row g-2">
               <div class="col-sm-3">
                   <select class="form-select">
                       <option selected>Année/Mois</option>
                       <option value="1">Option 1</option>
                       <option value="2">Option 2</option>
                   </select>
               </div>
               <div class="col-sm-3">
                   <select class="form-select">
                       <option selected>Jour</option>
                       <option value="1">Option 1</option>
                       <option value="2">Option 2</option>
                   </select>
               </div>
               <div class="col-sm-3">
                    <select class="form-select" name="type_document">
                        <option selected value="">Type de Document</option>
                        <?php $__currentLoopData = $type_documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type_document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type_document->id_type_document); ?>"><?php echo e($type_document->libelle); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
               </div>
               <div class="col-sm-3">
                <select class="form-select" name="direction">
                    <option selected value="">Direction</option>
                    <?php $__currentLoopData = $directions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $direction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($direction->id_direction); ?>"><?php echo e($direction->nom); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
           </div>
          
       </div>

       <div class="row g-4">
        <div class="col-sm-4 col-xl-2">
            <div class="bg-primary rounded-3 d-flex flex-column align-items-start p-4" style="border-radius: 30px !important;">
                <i class="fa fa-file fa-3x text-white mb-3"></i>
                <p class="mb-2 text-white fw-bold">Rang par Nombre de Document</p>
                <div class="d-flex align-items-center">
                    <h1 class="mb-0" style="font-size: 3rem;">1</h1>
                    <span style="font-size: 1rem; position: relative; top: -0.5rem; color: #ffff;">er</span>
                    <a href="#" class="d-inline-block rounded-circle bg-violet text-white p-2 ms-4" style="background-color: #6a0dad;">
                        <i class="fa-solid fa-arrow-trend-up"></i>
                    </a>
                </div>
            </div>
        </div>
    
        <div class="col-sm-4 col-xl-2">
            <div class="bg-primary rounded-3 d-flex flex-column align-items-start p-4" style="border-radius: 30px !important;">
                <i class="fa fa-download fa-3x text-white mb-3"></i>
                <p class="mb-2 text-white fw-bold">Rang par <br> temps de Traitement</p>
                <div class="d-flex align-items-center">
                    <h1 class="mb-0" style="font-size: 3rem;">1</h1>
                    <span style="font-size: 1rem; position: relative; top: -0.5rem; color: #ffff;">er</span>
                    <a href="#" class="d-inline-block rounded-circle bg-ping text-white p-2 ms-4" style="background-color: #ad0d80;">
                        <i class="fa-solid fa-arrow-trend-up"></i>
                    </a>
                </div>
            </div>
        </div>
    
        <div class="col-sm-4 col-xl-3">
            <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-3 mb-3"> <!-- Réduire le padding et ajouter une marge en bas -->
                <i class="fa fa-calculator fa-2x text-primary"></i> <!-- Réduire la taille de l'icône -->
                <p class="mb-2 text-white fw-bold">AGUIPEX</p>
                <div class="ms-3" style="height: 100px"> <!-- Réduire la hauteur -->
                    <div class="mb-2">
                        <p class="mb-1">Documents</p>
                        <h6 class="mb-0"><?php echo e($documentsCount); ?></h6>
                    </div>
                    <div class="mb-2">
                        <p class="mb-1">Montant total :</p>
                        <h6 class="mb-0"><?php echo e($totalAmount); ?> GNF</h6>
                    </div>
                </div>
            </div>
        
            <div class="bg-secondary rounded p-6">
                <!-- Tabs pour le filtrage -->
                <ul class="nav nav-tabs mb-3">
                    <li class="nav-item">
                        <a class="nav-link active" href="#">Tous</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Traiter</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Non Traités</a>
                    </li>
                </ul>
            
                <!-- Section principale avec chiffres et cercle -->
                <div class="d-flex justify-content-between align-items-center">

                    <!-- Cercle d'analyse -->
                    <div class="position-relative m-1" style="width: 120px; height: 120px; flex-shrink: 0;">
                        <canvas id="analysis-circle" width="120" height="120"></canvas>
                        <div class="position-absolute top-50 start-50 translate-middle text-white fw-bold" style="font-size: 1.5rem;">
                            75% <!-- Remplacez par la valeur dynamique du pourcentage -->
                        </div>
                    </div>

                    <!-- Nombre de documents traités, en cours et non traités -->
                    <div class="text-white" style="flex: 1; padding-left:20px;">
                        <p class="mb-1"><strong>800</strong> Traités </p>
                        <p class="mb-1"><strong>300</strong> En Cours </p>
                        <p class="mb-1"><strong>134</strong> Non Traités</p>
                    </div>
            
                    
                </div>
            </div>
            
            <script>
                // Script pour dessiner le cercle d'analyse
                const canvas = document.getElementById('analysis-circle');
                const ctx = canvas.getContext('2d');
                const percentage = 75; // Remplacez par la valeur dynamique du pourcentage
                const radius = 50; // Augmenté pour s'adapter à un cercle plus grand
                const startAngle = -0.5 * Math.PI; // Démarre à la position "12h"
                const endAngle = startAngle + (percentage / 100) * 2 * Math.PI;
            
                // Cercle de fond
                ctx.beginPath();
                ctx.arc(60, 60, radius + 10, 0, 2 * Math.PI, false);
                ctx.fillStyle = '#6c757d'; // Couleur de fond
                ctx.fill();
                ctx.closePath();
            
                // Cercle de pourcentage
                ctx.beginPath();
                ctx.arc(60, 60, radius, startAngle, endAngle, false);
                ctx.lineTo(60, 60);
                ctx.fillStyle = '#007bff'; // Couleur du cercle
                ctx.fill();
                ctx.closePath();
            </script>
            
            
            
        </div>
        
    
        <div class="col-sm-4 col-xl-5"> <!-- Ajustez la colonne pour plus d'espace -->
            <div class="bg-secondary text-center rounded p-4">
                <div class="d-flex align-items-center justify-content-between mb-4">
                    
                    
                </div>
                <canvas id="salse-revenue" width="600" height="300"></canvas> <!-- Augmenter la taille -->
            </div>
        </div>
    </div>
    
   <!-- Sale & Revenue End -->

   <!-- Sales Chart Start -->
   <div class="container-fluid pt-4 px-4">
    <div class="row g-4">
     <div class="col-sm-8 col-xl-4">
         <div class="text-left p-4"> <!-- Suppression du fond et alignement à gauche -->
             <div class="d-flex align-items-center justify-content-between mb-4">
                 <h6 class="text-white">Veuillez Choisir l'Axe d'analyse</h6>
             </div>
     
             <!-- Tabs for analysis options -->
             <ul class="nav nav-tabs mb-3 justify-content-start"> <!-- Alignement des onglets à gauche -->
                 <li class="nav-item">
                     <a class="nav-link active text-white" href="#">Années</a>
                 </li>
                 <li class="nav-item">
                     <a class="nav-link text-white" href="#">Mois</a>
                 </li>
                 <li class="nav-item">
                     <a class="nav-link text-white" href="#">Jours</a>
                 </li>
             </ul>
     
             <!-- Analysis results -->
             <div class="text-white mt-3">
                 <!-- First result -->
                 <div class="d-flex align-items-center mb-4">
                     <canvas class="me-3" id="circle1" width="50" height="50"></canvas>
                     <div>
                         <h5 class="mb-0">45 Minutes</h5>
                         <small class="d-block">Top Performance Temps</small>
                         <small>Lundi 12 MAI 2024</small>
                     </div>
                 </div>
     
                 <!-- Second result -->
                 <div class="d-flex align-items-center mb-4">
                     <canvas class="me-3" id="circle2" width="50" height="50"></canvas>
                     <div>
                         <h5 class="mb-0">60 Minutes</h5>
                         <small class="d-block">Moyen Performance Temps</small>
                         <small>Lundi 12 MAI 2024</small>
                     </div>
                 </div>
     
                 <!-- Third result -->
                 <div class="d-flex align-items-center">
                     <canvas class="me-3" id="circle3" width="50" height="50"></canvas>
                     <div>
                         <h5 class="mb-0">98 Minutes</h5>
                         <small class="d-block">Mauvaise Performance Temps</small>
                         <small>Mardi 22 AOUT 2024</small>
                     </div>
                 </div>
             </div>
         </div>
     </div>
     
     <script>
         // Function to draw the analysis circles
         function drawCircle(canvasId, percentage, color) {
             const canvas = document.getElementById(canvasId);
             const ctx = canvas.getContext('2d');
             const radius = 20;
             const startAngle = -0.5 * Math.PI;
             const endAngle = startAngle + (percentage / 100) * 2 * Math.PI;
     
             // Background circle
             ctx.beginPath();
             ctx.arc(25, 25, radius, 0, 2 * Math.PI, false);
             ctx.fillStyle = '#6c757d';
             ctx.fill();
             ctx.closePath();
     
             // Foreground circle
             ctx.beginPath();
             ctx.arc(25, 25, radius, startAngle, endAngle, false);
             ctx.lineTo(25, 25);
             ctx.fillStyle = color;
             ctx.fill();
             ctx.closePath();
         }
     
         // Draw the circles with the corresponding percentages and colors
         drawCircle('circle1', 75, '#28a745'); // Green for Top Performance
         drawCircle('circle2', 50, '#17a2b8'); // Blue for Medium Performance
         drawCircle('circle3', 30, '#dc3545'); // Red for Bad Performance
     </script>
     
     
        <div class="col-sm-12 col-xl-8">
            <div class="bg-secondary rounded h-100 p-4">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover">
                        <thead>
                            <tr class="text-center text-uppercase">
                                <th scope="col">#</th>
                                <th scope="col">Direction</th>
                                <th scope="col">Date</th>
                                <th scope="col">Montant</th>
                                <th scope="col">Type de document</th>
                                <th scope="col">Ministre</th>
                                <th scope="col">Temps TM</th>
                                <th scope="col">Temps DIR</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(isset($documents)): ?>
                                <?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><?php echo e(($i + 1)); ?></th>
                                        <td><?php echo e($document->direction->libelle ?? 'Non spécifié'); ?></td>
                                        <td><?php echo e($document->created_at->format('d/m/Y')); ?></td>
                                        <td><?php echo e($document->montant); ?></td>
                                        <td><?php echo e($document->libelle); ?></td>
                                        <td><?php echo e($document->user->name ?? 'Non spécifié'); ?>

                                        <td> <!-- Temps TM (logique) -->
                                            <?php echo e($document->etat == 1 ? 'Actif' : 'Inactif'); ?>

                                        </td>
                                        <td> <!-- Temps DIR (logique) -->
                                            <!--  logique  -->
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group" role="group">
                                                <a class="btn btn-warning" href="<?php echo e(route('admin.type_document.edit', $document->id_type_document)); ?>">Modifier</a>
                                                <a class="btn btn-danger" href="#" onclick="removeDocument(<?php echo e($document->id_type_document); ?>)">Supprimer</a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\MAMADI CISSE\Documents\MCIPME\digit-mcipme\resources\views/backend/pages/detail_dashboard.blade.php ENDPATH**/ ?>