<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <meta name="description" content="">
	    <meta name="author" content="Mamadi Cissé">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <link rel="icon" href="<?php echo e(url('assets/images/logos/armoirerie.png')); ?>">

	    <title><?php echo e(config('app.name', 'Laravel')); ?> - <?php echo $__env->yieldContent('title'); ?></title>

        <!-- Icon Font Stylesheet -->
        
        <!-- Fonts Awesome -->
        <link rel="stylesheet" href="<?php echo e(url('assets/css/font-awesome.css')); ?>">
        <script src="<?php echo e(url('assets/js/kit.fontawesome.js')); ?>"></script>

        <!-- Owl Carousel CSS -->
        <link href="<?php echo e(url('owlcarousel/assets/owl.carousel.min.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(url('owlcarousel/assets/owl.theme.default.min.css')); ?>" rel="stylesheet">

        <!-- Tempus Dominus CSS -->
        <link href="<?php echo e(url('tempusdominus/css/tempusdominus-bootstrap-4.min.css')); ?>" rel="stylesheet" />

        <!-- Customized Bootstrap Stylesheet -->
        <link href="<?php echo e(url('admin/css/customized-bootstrap.min.css')); ?>" rel="stylesheet">

        <!-- Template Stylesheet -->
        <link href="<?php echo e(url('admin/css/style.css')); ?>" rel="stylesheet">
        
        <!-- Hightcharts JS -->
        <script src="<?php echo e(asset('highcharts/highcharts.js')); ?>"></script>
        <script src="<?php echo e(asset('highcharts/highcharts-3d.js')); ?>"></script>
        <script src="<?php echo e(asset('highcharts/modules/exporting.js')); ?>"></script>
        <script src="<?php echo e(asset('highcharts/modules/export-data.js')); ?>"></script>
        <script src="<?php echo e(asset('highcharts/modules/accessibility.js')); ?>"></script>
        
        <!-- DataTables  CSS -->
        <link rel="stylesheet" href="<?php echo e(url('dataTables/css/datatables.min.css')); ?>">
        
        <!-- Sweetalert2  CSS -->
        <link rel="stylesheet" href="<?php echo e(url('assets/css/sweetalert2.min.css')); ?>">
    </head>
    <body>
        <div class="container-fluid position-relative d-flex p-0">
            <!-- Spinner -->
            <?php echo $__env->make('backend.layouts.inc._spinner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- Sidebar -->
            <?php echo $__env->make('backend.layouts.inc._sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- Content Start -->
            <div class="content">
                <!-- Navbar -->
                <?php echo $__env->make('backend.layouts.inc._navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                
                <?php echo $__env->yieldContent('content'); ?>

                <!-- Footer -->
                <?php echo $__env->make('backend.layouts.inc._footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <!-- Content End -->
            
            <!-- Back to Top -->
            <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="fas fa-arrow-up"></i></a>
        </div>

        <!-- JavaScript Libraries -->
        <script src="<?php echo e(url('assets/js/jquery-3.7.1.min.js')); ?>"></script>
        <script src="<?php echo e(url('bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
        <script src="<?php echo e(url('chart/chart.min.js')); ?>"></script>
        <script src="<?php echo e(url('easing/easing.min.js')); ?>"></script>
        <script src="<?php echo e(url('waypoints/waypoints.min.js')); ?>"></script>
        <script src="<?php echo e(url('owlcarousel/owl.carousel.min.js')); ?>"></script>
        <script src="<?php echo e(url('tempusdominus/js/moment.min.js')); ?>"></script>
        <script src="<?php echo e(url('tempusdominus/js/moment-timezone.min.js')); ?>"></script>
        <script src="<?php echo e(url('tempusdominus/js/tempusdominus-bootstrap-4.min.js')); ?>"></script>

        <!-- Template Javascript -->
        <script src="<?php echo e(url('admin/js/main.js')); ?>"></script>

        <!-- Custom JS -->
        <script src="<?php echo e(url('assets/js/main.js')); ?>"></script>

        <!-- Sweetalert2 JS -->
        <script src="<?php echo e(url('assets/js/sweetalert2.all.min.js')); ?>"></script>
        
        <!-- CKEditor -->
        <script src="<?php echo e(url('ckeditor5/ckeditor.js')); ?>"></script>

        <!-- CKEditor Configuration -->
        <script>
            ClassicEditor
                .create(document.querySelector( '#ckeditor' ), {
                    toolbar: {
                        items: [
                            'exportPDF','exportWord', '|',
                            'findAndReplace', 'selectAll', '|',
                            'heading', '|',
                            'bold', 'italic', 'strikethrough', 'underline', 'code', 'subscript', 'superscript', 'removeFormat', '|',
                            'bulletedList', 'numberedList', 'todoList', '|',
                            'outdent', 'indent', '|',
                            'undo', 'redo',
                            '-',
                            'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor', 'highlight', '|',
                            'alignment', '|',
                            'link', 'insertImage', 'blockQuote', 'insertTable', 'mediaEmbed', 'codeBlock', 'htmlEmbed', '|',
                            'specialCharacters', 'horizontalLine', 'pageBreak', '|',
                            'textPartLanguage', '|',
                            'sourceEditing'
                        ],
                        shouldNotGroupWhenFull: false
                    },
                    fontFamily: {
                        options: [
                            'default',
                            'Arial, Helvetica, sans-serif',
                            'Courier New, Courier, monospace',
                            'Georgia, serif',
                            'Lucida Sans Unicode, Lucida Grande, sans-serif',
                            'Tahoma, Geneva, sans-serif',
                            'Times New Roman, Times, serif',
                            'Trebuchet MS, Helvetica, sans-serif',
                            'Verdana, Geneva, sans-serif'
                        ],
                        supportAllValues: true
                    },
                    fontSize: {
                        options: [ 10, 12, 14, 'default', 18, 20, 22 ],
                        supportAllValues: true
                    },
                    ckfinder: {
                        uploadUrl: "",
                        options: {
                            resourceType: 'Images'
                        }
                    }                    
                })
                .then(editor => {
                    console.log(editor);
                })
                .catch(error => {
                    console.error(error);
                }
            );
        </script>

        <!-- DataTables  JS -->
        <script src="<?php echo e(url('dataTables/js/datatables.min.js')); ?>"></script>
        <script src="<?php echo e(url('dataTables/js/pdfmake.min.js')); ?>"></script>
        <script src="<?php echo e(url('dataTables/js/vfs_fonts.js')); ?>"></script>

        <script>
            new DataTable('.dataTables');
        </script>

        <!-- Information Message -->
        <?php if(session()->has('info')): ?>
            <script>
                Swal.fire({
                    // title: "Information!",
                    text: "<?php echo session()->get('info'); ?>",
                    icon: "info",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        <?php endif; ?>
        <!-- Success Message -->
        <?php if(session()->has('success')): ?>
            <script>
                Swal.fire({
                    // title: "Success!",
                    text: "<?php echo session()->get('success'); ?>",
                    icon: "success",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        <?php endif; ?>
        <!-- Warning Message -->
        <?php if(session()->has('warning')): ?>
            <script>
                Swal.fire({
                    // title: "Warning!",
                    text: "<?php echo session()->get('warning'); ?>",
                    icon: "warning",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        <?php endif; ?>
        <!-- Error Message -->
        <?php if(session()->has('error')): ?>
            <script>
                Swal.fire({
                    // title: "Error!",
                    text: "<?php echo session()->get('error'); ?>",
                    icon: "error",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        <?php endif; ?>
        
        <!-- Auto Log Out -->
        <?php if(auth()->guard()->check()): ?>
            <script src="<?php echo e(url('session.js')); ?>"></script>
        <?php endif; ?>
    </body>
</html><?php /**PATH C:\Users\MAMADI CISSE\Documents\MCIPME\digit-mcipme\resources\views/backend/layouts/admin.blade.php ENDPATH**/ ?>