<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <meta name="description" content="">
	    <meta name="author" content="Ministère du Commerce de l'Industrie et des PME">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <link rel="icon" href="<?php echo e(url('assets/images/logos/armoirerie.png')); ?>">

	    <title><?php echo e(config('app.name', '')); ?> - <?php echo $__env->yieldContent('title'); ?></title>
        
        <!-- Bootstrap CSS -->
        <link href="<?php echo e(url('bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">

        <!-- Fonts Awesome -->
        <link rel="stylesheet" href="<?php echo e(url('assets/css/font-awesome.css')); ?>">
        <script src="<?php echo e(url('assets/js/kit.fontawesome.js')); ?>"></script>

        <!-- Core CSS -->
	    <link rel="stylesheet" href="<?php echo e(url('assets/css/aos.css')); ?>">
        
        <!-- Sweetalert2  CSS -->
        <link rel="stylesheet" href="<?php echo e(url('assets/css/sweetalert2.min.css')); ?>">
        
        <!-- Custom CSS -->
        <link rel="stylesheet" href="<?php echo e(url('assets/css/main.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(url('assets/css/slider.css')); ?>">
        
        <!-- Spinner CSS -->
        <link rel="stylesheet" href="<?php echo e(url('assets/css/spinner.css')); ?>">

        <!-- DataTables  CSS -->
        <link rel="stylesheet" href="<?php echo e(url('dataTables/css/datatables.min.css')); ?>">
    </head>
    <body style="margin-top: 92px; padding: 0 !important">
        <?php echo $__env->make('frontend.layouts.inc._spinner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="p-0" style="min-height: 100vh;">
            <!-- Navbar -->
            <?php echo $__env->make('frontend.layouts.inc._navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php if(!Route::is('home')): ?>
                <!-- Banner -->
                <div class="p-2 text-center" style="background: url(<?php echo e(url('assets/images/banners/banner-3.png')); ?>)">
                    <img src="<?php echo e(url('assets/images/logos/branding_guinee.png')); ?>" width="90" alt="">
                </div>
            <?php endif; ?>
            <?php if(Route::is('home')): ?>
                <!-- Slider -->
                <?php echo $__env->make('frontend.layouts.inc._slider', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
            <main>
                <?php echo $__env->yieldContent('content'); ?>
            </main>
            <!-- Footer -->
            <?php echo $__env->make('frontend.layouts.inc._footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <!-- Jquery 3.7.1 -->
	    <script src="<?php echo e(url('assets/js/jquery-3.7.1.min.js')); ?>"></script>

        <!-- Core JS -->
        <script src="<?php echo e(url('assets/js/aos.js')); ?>"></script>
        <script src="<?php echo e(url('ckeditor5/ckeditor.js')); ?>"></script>

        <!-- Bootstrap JS -->
        <script src="<?php echo e(url('bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>

        <!-- Custom JS -->
        <script src="<?php echo e(url('assets/js/main.js')); ?>"></script>
        <!-- Spinner JS -->
        <script src="<?php echo e(url('assets/js/spinner.js')); ?>"></script>

        <!-- Sweetalert2 JS -->
        <script src="<?php echo e(url('assets/js/sweetalert2.all.min.js')); ?>"></script>

        <!-- CKEditor -->
        <script src="<?php echo e(url('ckeditor5/ckeditor.js')); ?>"></script>

        <!-- CKEditor Configuration -->
        <script>
            ClassicEditor
                .create(document.querySelector( '#ckeditor' ), {
                    toolbar: {
                        items: [
                            'exportPDF','exportWord', '|',
                            'findAndReplace', 'selectAll', '|',
                            'heading', '|',
                            'bold', 'italic', 'strikethrough', 'underline', 'code', 'subscript', 'superscript', 'removeFormat', '|',
                            'bulletedList', 'numberedList', 'todoList', '|',
                            'outdent', 'indent', '|',
                            'undo', 'redo',
                            '-',
                            'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor', 'highlight', '|',
                            'alignment', '|',
                            'link', 'insertImage', 'blockQuote', 'insertTable', 'mediaEmbed', 'codeBlock', 'htmlEmbed', '|',
                            'specialCharacters', 'horizontalLine', 'pageBreak', '|',
                            'textPartLanguage', '|',
                            'sourceEditing'
                        ],
                        shouldNotGroupWhenFull: false
                    },
                    fontFamily: {
                        options: [
                            'default',
                            'Arial, Helvetica, sans-serif',
                            'Courier New, Courier, monospace',
                            'Georgia, serif',
                            'Lucida Sans Unicode, Lucida Grande, sans-serif',
                            'Tahoma, Geneva, sans-serif',
                            'Times New Roman, Times, serif',
                            'Trebuchet MS, Helvetica, sans-serif',
                            'Verdana, Geneva, sans-serif'
                        ],
                        supportAllValues: true
                    },
                    fontSize: {
                        options: [ 10, 12, 14, 'default', 18, 20, 22 ],
                        supportAllValues: true
                    },
                    ckfinder: {
                        uploadUrl: "",
                        options: {
                            resourceType: 'Images'
                        }
                    }                    
                })
                .then(editor => {
                    console.log(editor);
                })
                .catch(error => {
                    console.error(error);
                }
            );
        </script>

        <!-- DataTables  JS -->
        <script src="<?php echo e(url('dataTables/js/datatables.min.js')); ?>"></script>
        <script src="<?php echo e(url('dataTables/js/pdfmake.min.js')); ?>"></script>
        <script src="<?php echo e(url('dataTables/js/vfs_fonts.js')); ?>"></script>

        <script>
            new DataTable('.dataTables');
        </script>

        <!-- Information Message -->
        <?php if(session()->has('info')): ?>
            <script>
                Swal.fire({
                    // title: "Information!",
                    text: "<?php echo session()->get('info'); ?>",
                    icon: "info",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        <?php endif; ?>
        <!-- Success Message -->
        <?php if(session()->has('success')): ?>
            <script>
                Swal.fire({
                    // title: "Success!",
                    text: "<?php echo session()->get('success'); ?>",
                    icon: "success",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        <?php endif; ?>
        <!-- Warning Message -->
        <?php if(session()->has('warning')): ?>
            <script>
                Swal.fire({
                    // title: "Warning!",
                    text: "<?php echo session()->get('warning'); ?>",
                    icon: "warning",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        <?php endif; ?>
        <!-- Error Message -->
        <?php if(session()->has('error')): ?>
            <script>
                Swal.fire({
                    // title: "Error!",
                    text: "<?php echo session()->get('error'); ?>",
                    icon: "error",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        <?php endif; ?>

        <!-- AOS JS -->
        <script>
            AOS.init();
        </script>
        
        <!-- Auto Log Out -->
        <?php if(auth()->guard()->check()): ?>
            <script src="<?php echo e(url('session.js')); ?>"></script>
        <?php endif; ?>
    </body>
</html><?php /**PATH C:\Users\MAMADI CISSE\Documents\MCIPME\digit-mcipme\resources\views/frontend/layouts/default.blade.php ENDPATH**/ ?>