<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Backend\DashboardController;
use App\Http\Controllers\Backend\AdminDemandeController;

Route::middleware(['auth', 'verified'])->group(function () {
    Route::controller(DashboardController::class)->group(function () {
        Route::prefix('dashboard')->group(function () {
            Route::get('/', 'index')->name('dashboard');
            Route::get('/dashboard/detail/{id_direction}', 'detailDashboard')->name('detailDashboard');
        });
    });
    Route::prefix('dashboard')->name('dashboard.')->group(function () {
        # Demande Routes
        Route::controller(AdminDemandeController::class)->prefix('/demandes')->name('demande.')->group(function () {
            Route::get('/list-of-demandes', 'index')->name('list');
            Route::get('/{slug}/list', 'demandeCategory')->name('category');
            Route::get('/orient/{demande}', 'orient')->name('orient');
            Route::post('/reject-demande/{demande}', 'reject')->name('reject');
            Route::get('/process-demande/{demande}', 'process')->name('process');
            Route::get('/{demande}/show-details', 'show')->name('show');
            Route::post('/process-validate/{demande}', 'validateProcess')->name('process.validate');
            Route::get('/edit-demande/{demande}', 'edit')->name('edit');
            Route::patch('/update-demande/{demande}', 'update')->name('update');
            Route::get('/delete-demande/{demande}', 'destroy')->name('delete');
            Route::get('/return/{demande}', 'return')->name('return');
            Route::post('/validate-return/{demande}', 'validateReturn')->name('validate.return');
        });
    });
});