<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\Auth\AuthenticationController;
use App\Http\Controllers\Auth\ForgotPasswordController;

Route::middleware('guest')->group(function () {
    # Register
    Route::controller(RegisterController::class)->group(function () {
        Route::prefix('register')->group(function () {
            Route::get('/', 'create')->name('register');
            Route::post('/store', 'store')->name('register.store');    
            Route::get('verify-email/{token}', 'verifyEmail')->name('verify.email');
        });
    });
    
    # Login
    Route::controller(AuthenticationController::class)->group(function () {
        Route::prefix('login')->group(function () {
            Route::get('/', 'create')->name('login');
            Route::post('/store', 'store')->name('login.store');    
        });
    });
    
    Route::prefix('password')->name('password.')->group(function () {
        Route::controller(ForgotPasswordController::class)->group(function () {
            Route::get('/reset', 'showLinkRequestForm')->name('request');
            Route::post('/email', 'sendResetLinkEmail')->name('email');    
        });
        Route::controller(ResetPasswordController::class)->group(function () {
            Route::get('/reset/{token}', 'showResetForm')->name('reset');
            Route::post('/reset', 'reset')->name('update');    
        });
    });
});

Route::middleware('auth')->group(function () {
    Route::get('/logout', [AuthenticationController::class, 'destroy'])->name('logout');    
});