<?php

use App\Http\Controllers\Frontend\PageController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\FileController;
use App\Http\Controllers\Backend\ProductController;
use App\Http\Controllers\Backend\ServiceController;
use App\Http\Controllers\Backend\MinisterController;
use App\Http\Controllers\Frontend\DemandeController;
use App\Http\Controllers\Backend\DirectionController;
use App\Http\Controllers\Backend\PromoteurController;
use App\Http\Controllers\Backend\ResponsableController;
use App\Http\Controllers\Backend\TypeDocumentController;
use App\Http\Controllers\Backend\CategorieDocumentController;

Route::controller(PageController::class)->group(function () {
    Route::get('/', 'index')->name('home');
    Route::get('/guide-to-the-procedures', 'guideToProcedures')->name('guide.to.procedures');
    Route::get('/contact', 'contactUs')->name('contact.us');
});

Route::middleware(['auth', 'verified'])->group(function () {
    # Demande Routes
    Route::prefix('demande')->name('demande.')->group(function () {
        Route::controller(DemandeController::class)->group(function () {
            Route::get('/list', 'index')->name('index');
            Route::get('/{slug}/list', 'demandeCategory')->name('category');
            Route::get('/add', 'add')->name('add');
            Route::post('/store', 'store')->name('store');
            Route::post('/show/{demande}', 'show')->name('show');
        });
    });

    Route::prefix('/minitere')->group(function(){
        Route::get('/', [MinisterController::class, 'index'])->name('minister.index');
        Route::get('/create', [MinisterController::class, 'create'])->name('minister.create');
        Route::get('/edit/{minister}', [MinisterController::class, 'edit'])->name('minister.edit');
        Route::get('/detail/{minister}', [MinisterController::class, 'detail'])->name('minister.detail');

        //Route d'action
        Route::post('/create', [MinisterController::class, 'store'])->name("minister.store");
        Route::put('/update/{minister}', [MinisterController::class, 'update'])->name("minister.update");
        Route::get('/delete/{minister}', [MinisterController::class, 'delete'])->name("minister.delete");
        
    });

    Route::prefix('/direction')->group(function(){
        Route::get('/', [DirectionController::class, 'index'])->name('direction.index');
        Route::get('/create', [DirectionController::class, 'create'])->name('direction.create');
        Route::get('/edit/{direction}', [DirectionController::class, 'edit'])->name('direction.edit');
        Route::get('/detail/{direction}', [DirectionController::class, 'detail'])->name('direction.detail');

        //Route d'action
        Route::post('/create', [DirectionController::class, 'store'])->name("direction.store");
        Route::put('/update/{direction}', [DirectionController::class, 'update'])->name("direction.update");
        Route::get('/delete/{direction}', [DirectionController::class, 'delete'])->name("direction.delete");
        
    });

    Route::prefix('/service')->group(function(){
        Route::get('/', [ServiceController::class, 'index'])->name('service.index');
        Route::get('/create', [ServiceController::class, 'create'])->name('service.create');
        Route::get('/edit/{service}', [ServiceController::class, 'edit'])->name('service.edit');
        Route::get('/detail/{service}', [ServiceController::class, 'detail'])->name('service.detail');

        //Route d'action
        Route::post('/create', [ServiceController::class, 'store'])->name("service.store");
        Route::put('/update/{service}', [ServiceController::class, 'update'])->name("service.update");
        Route::get('/delete/{service}', [ServiceController::class, 'delete'])->name("service.delete");
        
    });

    Route::prefix('/responsable')->group(function(){
        Route::get('/', [ResponsableController::class, 'index'])->name('responsable.index');
        Route::get('/create', [ResponsableController::class, 'create'])->name('responsable.create');
        Route::get('/edit/{responsable}', [ResponsableController::class, 'edit'])->name('responsable.edit');
        Route::get('/detail/{responsable}', [ResponsableController::class, 'detail'])->name('responsable.detail');

        //Route d'action
        Route::post('/create', [ResponsableController::class, 'store'])->name("responsable.store");
        Route::put('/update/{responsable}', [ResponsableController::class, 'update'])->name("responsable.update");
        Route::get('/delete/{responsable}', [ResponsableController::class, 'delete'])->name("responsable.delete");
        
    });

    Route::prefix('/promoteur')->group(function(){
        Route::get('/', [PromoteurController::class, 'index'])->name('promoteur.index');
        Route::get('/create', [PromoteurController::class, 'create'])->name('promoteur.create');
        Route::get('/edit/{promoteur}', [PromoteurController::class, 'edit'])->name('promoteur.edit');
        Route::get('/detail/{promoteur}', [PromoteurController::class, 'detail'])->name('promoteur.detail');

        //Route d'action
        Route::post('/create', [PromoteurController::class, 'store'])->name("promoteur.store");
        Route::put('/update/{promoteur}', [PromoteurController::class, 'update'])->name("promoteur.update");
        Route::get('/delete/{promoteur}', [PromoteurController::class, 'delete'])->name("promoteur.delete");
        
    });

    Route::prefix('/categorie_document')->group(function(){
        Route::get('/', [CategorieDocumentController::class, 'index'])->name('categorie_document.index');
        Route::get('/create', [CategorieDocumentController::class, 'create'])->name('categorie_document.create');
        Route::get('/edit/{categorie}', [CategorieDocumentController::class, 'edit'])->name('categorie_document.edit');
        Route::get('/detail/{categorie}', [CategorieDocumentController::class, 'detail'])->name('categorie_document.detail');

        //Route d'action
        Route::post('/create', [CategorieDocumentController::class, 'store'])->name("categorie_document.store");
        Route::put('/update/{categorie}', [CategorieDocumentController::class, 'update'])->name("categorie_document.update");
        Route::get('/delete/{categorie}', [CategorieDocumentController::class, 'disable'])->name("categorie_document.delete");
        
    });

    Route::prefix('/type_document')->group(function(){
        Route::get('/', [TypeDocumentController::class, 'index'])->name('type_document.index');
        Route::get('/create', [TypeDocumentController::class, 'create'])->name('type_document.create');
        Route::get('/edit/{type}', [TypeDocumentController::class, 'edit'])->name('type_document.edit');
        Route::get('/detail/{type}', [TypeDocumentController::class, 'detail'])->name('type_document.detail');

        //Route d'action
        Route::post('/create', [TypeDocumentController::class, 'store'])->name("type_document.store");
        Route::put('/update/{type}', [TypeDocumentController::class, 'update'])->name("type_document.update");
        Route::get('/delete/{type}', [TypeDocumentController::class, 'disable'])->name("type_document.delete");
        
    });

    Route::prefix('/produit')->group(function(){
        Route::get('/', [ProductController::class, 'index'])->name('produit.index');
        Route::get('/create', [ProductController::class, 'create'])->name('produit.create');
        Route::get('/edit/{produit}', [ProductController::class, 'edit'])->name('produit.edit');
        Route::get('/detail/{produit}', [ProductController::class, 'detail'])->name('produit.detail');

        //Route d'action
        Route::post('/create', [ProductController::class, 'store'])->name("produit.store");
        Route::put('/update/{produit}', [ProductController::class, 'update'])->name("produit.update");
        Route::get('/delete/{produit}', [ProductController::class, 'disable'])->name("produit.delete");
        
    });
});

