<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Backend\UserController;
use App\Http\Controllers\Backend\RolesController;
use App\Http\Controllers\Backend\PermissionsController;

Route::middleware(['auth', 'role:super_admin|admin|ministre|directeur'])->group(function () {
    Route::prefix('admin')->name('admin.')->group(function () {
        # User Routes
        Route::controller(UserController::class)->prefix('/users')->name('user.')->group(function () {
            Route::get('/', 'index')->name('list');
            Route::get('/add-user', 'add')->name('add');
            Route::post('/store-user', 'store')->name('store');
            Route::get('/edit-user/{user}', 'edit')->name('edit');
            Route::patch('/update-user/{user}', 'update')->name('update');
            Route::get('/show-details/{user}', 'show')->name('details');
            Route::post('/assign-role/{user}', 'assignRole')->name('assign.role');
            Route::get('/remove-role/{user}/{role}', 'removeRole')->name('remove.role');
            Route::post('/grant-permission/{user}', 'grantPermission')->name('grant.permission');
            Route::get('/revoke-permission/{user}/{permission}', 'revokePermission')->name('revoke.permission');
            Route::get('/delete-user/{user}', 'destroy')->name('delete');
        });
        # Roles Routes
        Route::controller(RolesController::class)->prefix('/roles')->name('role.')->group(function () {
            Route::get('/', 'index')->name('list');
            Route::get('/add-role', 'add')->name('add');
            Route::post('/store-role', 'store')->name('store');
            Route::get('/edit-role/{role}', 'edit')->name('edit');
            Route::patch('/update-role/{role}', 'update')->name('update');
            Route::get('/show-details/{role}', 'show')->name('details');
            Route::post('/grant-permission/{role}', 'grantPermission')->name('grant.permission');
            Route::get('/revoke-permission/{role}/{permission}', 'revokePermission')->name('revoke.permission');
            Route::get('/delete-role/{role}', 'destroy')->name('delete');
        });
        # Permissions Routes
        Route::controller(PermissionsController::class)->prefix('/permissions')->name('permission.')->group(function () {
            Route::get('/', 'index')->name('list');
            Route::get('/add-permission', 'add')->name('add');
            Route::post('/store-permission', 'store')->name('store');
            Route::get('/edit-permission/{permission}', 'edit')->name('edit');
            Route::patch('/update-permission/{permission}', 'update')->name('update');
            Route::get('/delete-permission/{permission}', 'destroy')->name('delete');
        });
    });
});