@extends('frontend.layouts.default')

@section('title', 'Bienvenue')

@section('content')
<div class="container-fluid d-flex p-0">
    <div id="home-1" class="col-md-6 col-xl-6">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            {{-- <div id="amineText" class="text-center">
                <p>
                    Le ministère du Commerce, de l’Industrie et des PME a pour mission la conception, l’élaboration et
                    la mise en œuvre de la politique du gouvernement dans les domaines du commerce, de l’industrie et
                    des PME, des investissements et du partenariat public privé et d’en assurer le suivi.
                </p>
            </div> --}}
        </div>
    </div>
    <div id="home-2" class="container-fluid col-xs-12 col-sm-12 col-md-6 col-xl-6 bg-light">
        <div class="row" style="min-height: 100vh;">
            <div class="text-center p-3">
                <img id="logo-anime" src="{{ url('assets/images/logos/logo_plaged.png') }}" width="500" alt="">
                <img class="logo_branding" src="{{ url('assets/images/logos/branding_guinee.png') }}" width="130"
                    alt="">
            </div>
            <div class="description">
                <p class="text-justify">
                    <strong>
                        Le ministère du Commerce, de l’Industrie et des PME a pour mission la conception, l’élaboration
                        et
                        la mise en œuvre de la politique du gouvernement dans les domaines du commerce, de l’industrie
                        et
                        des PME, des investissements et du partenariat public privé et d’en assurer le suivi.
                    </strong>
                </p>
            </div>
            <div class="text-center">
                @if (Route::has('login'))
                <nav>
                    @auth
                        @if (!auth()->user()->hasAnyRole(Admin::getAllImportantRoles()))
                        <a class="btn btn-secondary btn-lg text-primary mb-3" href="{{ route('demande.index') }}">
                            Mes demandes
                        </a>
                        <a class="btn btn-secondary btn-lg text-primary mb-3" href="{{ route('demande.add') }}">
                            Faire une demande
                        </a>
                        @endif
                        @hasanyrole(Admin::getAllImportantRoles())
                        <a class="btn btn-secondary btn-lg text-primary mb-3" href="{{ route('dashboard') }}">
                            Dashboard
                        </a>
                        @endhasanyrole
                        <a href="#" class="btn btn-secondary btn-lg mb-3" onclick="window.location.href = '/logout'">
                            Se déconnecter
                        </a>
                    @else
                        <a class="btn btn-secondary btn-lg text-primary mb-3" href="{{ route('login') }}">
                            Se connecter
                        </a>
                        @if (Route::has('register'))
                        <a class="btn btn-secondary btn-lg text-primary mb-3" href="{{ route('register') }}">
                            S'inscrire
                        </a>
                        @endif
                    @endauth
                </nav>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection