@extends('frontend.layouts.default')

@section('title', 'Modification de la demande')

@section('content')
    <div id="add-file-form" class="container-fluid py-4" style="background: url({{ url('assets/images/ministre-diaka-sidibe-2.jpg') }}); background-repeat: no-repeat; background-size: cover;">
        <div class="container-fluid">
            <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
                <div class="col-12 col-sm-11 col-md-9 col-lg-8 col-xl-6">
                    <div class="bg-primary rounded p-4 p-sm-5 my-4 mx-3">
                        <form action="{{ route('dashboard.demande.update', $demande->id_demande) }}" method="post" enctype="multipart/form-data">
                            @csrf
                            @method('PATCH')
                            <div class="d-flex align-items-center justify-content-center mb-3">
                                <a href="https://mcipme.gov.gn/" target="_blank">
                                    <img src="{{ url('assets/images/logos/logo_plaged.png') }}" width="200" alt="">
                                </a>
                            </div>
                            <div class="text-center mb-3">
                                {{-- <a href="{{ route('home') }}" class="text-decoration-none">
                                    <h3 class="text-primary"><i class="fa fa-user-edit me-2"></i>PAI</h3>
                                </a> --}}
                                <h3 class="text-secondary"><i class="fa fa-user-edit me-2"></i>&nbsp;Modification de la demande</h3>
                            </div>
                            <div class="row">
                                <!-- Demande Title -->
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="p-1 my-3" style="background-color: beige; font-size: 14px;">Le symbole astérisque <strong><code>( * )</code></strong> signifie que le champ est obligatoire</div>
                                    <div class="form-floating mb-3">
                                        <input type="text" name="demande_title" value="{{ old('demande_title') ?? $demande->titre_demande }}" class="form-control" disabled id="floatingText" placeholder="">
                                        <label for="floatingText">Titre de la demande :</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <!-- Document Type -->
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="form-floating mb-3">
                                        <input type="text" name="demande_title" value="{{ old('demande_title') ?? $demande->typeDocument->libelle }}" class="form-control" disabled id="floatingText" placeholder="">
                                        <label for="floatingText">Type Document :</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <!-- Attachment -->
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="mb-3">
                                        <input type="file" name="attachments[]" hidden multiple id="real-file" />
                                        <button type="button" id="custom-button" required class="bg-white w-100 text-start @error('attachments') is-invalid @enderror" style="height:calc(3.6rem);line-height:1.25;border-radius: 5px; padding: 0 15px; border: 1px solid #ddd;" title="Rassurer vous d'avoir fusionner tous les documents en un seul fichier .pdf">
                                            Cliquer pour joindre les fonds de dossier : *
                                        </button>
                                        <div>
                                            <span id="file-name" class="text-success fw-bold"></span>
                                        </div>
                                        @error('attachments')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-secondary py-3 w-100 mb-4"><i class="fas fa-save"></i> Valider la modification</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
