
@extends('frontend.layouts.default')

@section('title', 'Demandes rejetées')

@section('content')
<div class="container-fluid py-5 my-5">
    <!-- List of rejected requests -->
    <div>
        <div>
            <div class="container my-4">
                <div style="border: 2px inset #007481; border-radius: 50px;"
                    class="my-4 p-3 bg-primary text-secondary text-center fw-bold text-uppercase">Liste des demandes
                    rejetées</div>
            </div>
            <div id="table" class="container">
                <table class="table table-bordered table-striped table-hover dataTables">
                    <thead class="table-success">
                        <tr>
                            <th>N°</th>
                            <th>Titre Demande</th>
                            <th>Type Demande</th>
                            <th>Document(s) Joint(s)</th>
                            <th>Date Envoi</th>
                            <th>Direction</th>
                            <th>Staut Demande</th>
                            <th>Date Rejet</th>
                            <th>Motif Rejet</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if (isset($demandes) && $demandes->count() > 0)
                        @foreach ($demandes as $key => $demande_r)
                        <tr>
                            <td>{{ ($key + 1) }}</td>
                            <td>{{ $demande_r->demande->titre_demande }}</td>
                            <td>{{ $demande_r->demande->typeDocument->libelle }}</td>
                            <td>
                                @php $attachments = $demande_r->demande->documents_joints; @endphp
                                @foreach ($attachments as $attachment)
                                <div class="mb-3">
                                    <a target="_blank" href="{{ url('storage/documents_recus/'.$attachment) }}"
                                        title="Cliquer pour visualier ou télécharger">
                                        {{ $attachment }}
                                    </a>
                                </div>
                                @endforeach
                            </td>
                            <td>{{ Utilities::formatDate($demande_r->demande->date_demande) }}</td>
                            <td>{{ $demande_r->demande->typeDocument->service->direction->nom }}</td>
                            @php
                            $color = '';
                            if ($demande_r->demande->id_statut_demande == 2){
                            $color = '#f2b707';
                            }
                            if ($demande_r->demande->id_statut_demande == 3){
                            $color = '#0cc0e4';
                            }
                            if ($demande_r->demande->id_statut_demande == 4){
                            $color = '#e443b1';
                            }
                            if ($demande_r->demande->id_statut_demande == 5){
                            $color = '#dc3545';
                            }
                            if ($demande_r->demande->id_statut_demande == 6){
                            $color = '#188050';
                            }
                            @endphp
                            <td class="fw-bold" style="color: {{ $color ?? '#444444' }}">
                                {{ $demande_r->demande->statutDemande->libelle }}
                            </td>
                            <td>{{ Utilities::formatDate($demande_r->date_rejet) }}</td>
                            <td class="text-center">
                                @if ($demande_r->motif_rejet != NULL)
                                <a class="btn btn-info" href="#" data-bs-toggle="modal"
                                    data-bs-target="#modalRejectDetail-{{ $demande_r->id_demande }}"
                                    title="Cliquer pour voir le détail">
                                    <i class="fa fa-eye"></i>
                                </a>
                                @endif
                            </td>
                        </tr>
                        <div class="modal fade" id="modalRejectDetail-{{ $demande_r->id_demande }}" tabindex="-1"
                            aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="bg-primary modal-content">
                                    <div class="modal-header bg-secondary">
                                        <h1 class="modal-title fs-5 text-primary" id="staticBackdropLabel">Motif du
                                            rejet de la demande</h1>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="p-4">
                                        {!! $demande_r->motif_rejet !!}
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary"
                                            data-bs-dismiss="modal">Quitter</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection