@extends('frontend.layouts.default')

@section('title', 'Demandes en attente de traitement')

@section('content')
<div class="container-fluid py-5 my-5">
    <!-- List of requests awaiting processing -->
    <div>
        <div class="container my-4">
            <div style="border: 2px inset #007481; border-radius: 50px;"
                class="my-4 p-3 bg-primary text-secondary text-center fw-bold text-uppercase">Liste des demandes en
                attente de traitement</div>
        </div>
        <div id="table" class="container">
            <table class="table table-bordered table-striped table-hover dataTables">
                <thead class="table-success">
                    <tr>
                        <th>N°</th>
                        <th>Titre Demande</th>
                        <th>Type Demande</th>
                        <th>Docuement(s) Joint(s)</th>
                        <th>Commentaire</th>
                        <th>Date Envoi</th>
                        <th>Staut Demande</th>
                        <th>Direction</th>
                    </tr>
                </thead>
                <tbody>
                    @if (isset($demandes) && $demandes->count() > 0)
                    @foreach ($demandes as $key => $demande)
                    <tr>
                        <td>{{ ($key + 1) }}</td>
                        <td>{{ $demande->titre_demande }}</td>
                        <td>{{ $demande->typeDocument->libelle }}</td>
                        <td>
                            @php $attachments = $demande->documents_joints; @endphp
                            @foreach ($attachments as $attachment)
                            <div class="mb-3">
                                <a target="_blank" href="{{ url('storage/documents_recus/'.$attachment) }}"
                                    title="Cliquer pour visualier ou télécharger">
                                    {{ $attachment }}
                                </a>
                            </div>
                            @endforeach
                        </td>
                        <td>{!! $demande->commentaire !!}</td>
                        <td>{{ Utilities::formatDate($demande->date_demande) }}</td>
                        @php
                        $color = '';
                        if ($demande->id_statut_demande == 2){
                        $color = '#f2b707';
                        }
                        if ($demande->id_statut_demande == 3){
                        $color = '#0cc0e4';
                        }
                        if ($demande->id_statut_demande == 4){
                        $color = '#e443b1';
                        }
                        if ($demande->id_statut_demande == 5){
                        $color = '#dc3545';
                        }
                        if ($demande->id_statut_demande == 6){
                        $color = '#188050';
                        }
                        @endphp
                        <td class="fw-bold" style="color: {{ $color ?? '#444444' }}">
                            {{ $demande->statutDemande->libelle }}
                        </td>
                        <td>{{ $demande->typeDocument->service->direction->nom }}</td>
                    </tr>
                    @endforeach
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection