@extends('frontend.layouts.default')

@section('title', 'Demandes traitées')

@section('content')
<div class="container-fluid py-5 my-5">
    <!-- List of processed requests -->
    <div>
        <div>
            <div class="container my-4">
                <div style="border: 2px inset #007481; border-radius: 50px;"
                    class="my-4 p-3 bg-primary text-secondary text-center fw-bold text-uppercase">Liste des demandes
                    traitées</div>
            </div>
            <div id="table" class="container">
                <table class="table table-bordered table-striped table-hover dataTables">
                    <thead class="table-success">
                        <tr>
                            <th>N°</th>
                            <th>Titre Demande</th>
                            <th>Type Demande</th>
                            <th>Date Envoi</th>
                            <th>Direction</th>
                            <th>Staut Demande</th>
                            <th>Date Traitement</th>
                            <th>Document Transmis</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if (isset($demandes) && $demandes->count() > 0)
                        @foreach ($demandes as $key => $demande_r)
                        <tr>
                            <td>{{ ($key + 1) }}</td>
                            <td>{{ $demande_r->demande->titre_demande }}</td>
                            <td>{{ $demande_r->demande->typeDocument->libelle }}</td>
                            <td>{{ Utilities::formatDate($demande_r->demande->date_demande) }}</td>
                            <td>{{ $demande_r->demande->typeDocument->service->direction->nom }}</td>
                            @php
                            $color = '';
                            if ($demande_r->demande->id_statut_demande == 2){
                            $color = '#f2b707';
                            }
                            if ($demande_r->demande->id_statut_demande == 3){
                            $color = '#0cc0e4';
                            }
                            if ($demande_r->demande->id_statut_demande == 4){
                            $color = '#e443b1';
                            }
                            if ($demande_r->demande->id_statut_demande == 5){
                            $color = '#dc3545';
                            }
                            if ($demande_r->demande->id_statut_demande == 6){
                            $color = '#188050';
                            }
                            @endphp
                            <td class="fw-bold" style="color: {{ $color ?? '#444444' }}">
                                {{ $demande_r->demande->statutDemande->libelle }}
                            </td>
                            <td>{{ Utilities::formatDate($demande_r->date_traitement) }}</td>
                            <td>
                                @php $attachments = $demande_r->documents_joints; @endphp
                                @foreach ($attachments as $attachment)
                                <div class="mb-3">
                                    <a class="fw-bold mb-1 text-center d-block" target="_blank" href="{{ url('storage/documents_envoyes/'.$attachment) }}"
                                        title="Cliquer pour visualier ou télécharger">
                                        {{ $attachment }}
                                    </a><iframe class="mb-3" src="{{ url('storage/documents_envoyes/'.$attachment) }}" height="100px" 
                                        frameborder="0"></iframe>
                                    @endforeach
                                </div>
                            </td>
                        </tr>
                        @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection