@extends('frontend.layouts.default')

@section('title', 'Faire une demande')

@section('content')
    <div id="add-file-form" class="container-fluid py-5" style="background: url({{ url('assets/images/ministre-diaka-sidibe-2.jpg') }}); background-repeat: no-repeat; background-size: cover;">
        <div class="container-fluid">
            <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
                <div class="col-12 col-sm-11 col-md-9 col-lg-8 col-xl-6">
                    <div class="bg-primary rounded p-4 p-sm-5 my-4 mx-3">
                        <form action="{{ route('demande.store') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="d-flex align-items-center justify-content-center mb-3">
                                <a href="https://mcipme.gov.gn/" target="_blank">
                                    <img src="{{ url('assets/images/logos/logo_plaged.png') }}" width="200" alt="">
                                </a>
                            </div>
                            <div class="text-center mb-3">
                                {{-- <a href="{{ route('home') }}" class="text-decoration-none">
                                    <h3 class="text-primary"><i class="fa fa-user-edit me-2"></i>PAI</h3>
                                </a> --}}
                                <h3 class="text-secondary"><i class="fa fa-user-edit me-2"></i>&nbsp;Faire une Demande</h3>
                            </div>
                            <div class="row">
                                <!-- Demande Title -->
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="p-1 my-3" style="background-color: beige; font-size: 14px;">Le symbole astérisque <strong><code>( * )</code></strong> signifie que le champ est obligatoire</div>
                                    <div class="form-floating mb-3">
                                        <input type="text" name="demande_title" value="{{ old('demande_title') }}" class="form-control @error('demande_title') is-invalid @enderror" id="floatingText" placeholder="">
                                        <label for="floatingText">Titre de la demande * :</label>
                                        @error('demande_title')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <!-- Document Type -->
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="mb-3">
                                        <select name="document_type" class="form-select @error('document_type') is-invalid @enderror" style="height:calc(3.6rem);line-height:1.25;">
                                            <option value="">Document sollicité * :</option>
                                            @isset($typeDocuments)
                                                @foreach ($typeDocuments as $typeDocument)
                                                    <option {{ old('document_type') == $typeDocument->id_type_document ? 'selected' : '' }} value="{{ $typeDocument->id_type_document }}">{{ $typeDocument->libelle }} </option>
                                                @endforeach
                                            @endisset
                                        </select>
                                        @error('document_type')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>   
                            </div>
                            <div class="row">
                                <!-- Attachment -->
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="mb-3">
                                        <input type="file" name="attachments[]" hidden multiple id="real-file" />
                                        <button type="button" id="custom-button" class="bg-white w-100 text-start @error('attachments') is-invalid @enderror" style="height:calc(3.6rem);line-height:1.25;border-radius: 5px; padding: 0 15px; border: 1px solid #ddd;" title="Rassurer vous d'avoir fusionner tous les documents en un seul fichier .pdf">
                                            Cliquer pour joindre les fonds de dossier * :
                                        </button>
                                        <div>
                                            <span id="file-name" class="text-success fw-bold"></span>
                                        </div>
                                        @error('attachments')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <!-- Payment Mode -->
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="mb-3">
                                        <select name="payment_mode" class="form-select @error('payment_mode') is-invalid @enderror" style="height:calc(3.6rem);line-height:1.25;">
                                            <option value="">Mode de paiement :</option>
                                            @isset($modesPaiement)
                                                @foreach ($modesPaiement as $modePaiement)
                                                    <option {{ old('payment_mode') == $modePaiement->id_mode_paiement ? 'selected' : '' }} value="{{ $modePaiement->id_mode_paiement }}">{{ $modePaiement->libelle }} </option>
                                                @endforeach
                                            @endisset
                                        </select>
                                        @error('payment_mode')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>  
                            </div>
                            <div class="row">
                                <!-- Commentary -->
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="mb-3">
                                        <textarea name="commentary" id="ckeditor" cols="30" rows="2" class="form-control @error('commentary') is-invalid @enderror" placeholder="Commentaire :">{{ old('commentary') }}</textarea>
                                        @error('commentary')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-secondary py-3 w-100 mb-4"><i class="fas fa-save"></i> Envoyer la demande</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
