@php

    if (auth()->check() && !auth()->user()->hasAnyRole(Admin::getAllImportantRoles())) {
    $promoteur = Auth::user()->promoteur->id_promoteur;
    # Liste de toutes les demandes
    $allDemandes = App\Models\Demande::where('id_promoteur', $promoteur)->get();
    # Liste des demandes en attente de traitement
    $awaitingProcessingDemandes = App\Models\Demande::where(['id_statut_demande' => 1, 'id_promoteur' =>
    $promoteur])->get();
    # Liste des demandes en attente d'étude
    $awaitingStudyDemandes = App\Models\Demande::where(['id_statut_demande' => 2, 'id_promoteur' => $promoteur])->get();
    # Liste des demandes en attente d'examen
    $awaitingReviewDemandes = App\Models\Demande::where(['id_statut_demande' => 3, 'id_promoteur' => $promoteur])->get();
    # Liste des demandes en attente de modification
    $awaitingModificationDemandes = App\Models\DemandeRenvoyee::with(['demande' => function ($query) use ($promoteur) {
        $query->where('id_statut_demande', 4)
                ->where('id_promoteur', $promoteur);
    }])
    ->get()
    ->filter(function ($demandeRenvoyee) {
        return $demandeRenvoyee->demande !== null;
    })
    ->unique('id_demande');
    # Liste des demandes rejetées
    $rejectedDemandes = App\Models\DemandeRejetee::select('demande_rejetees.*')
    ->join('demandes', 'demandes.id_demande', '=', 'demande_rejetees.id_demande')
    ->where('demandes.id_statut_demande', 5)
    ->where('demandes.id_promoteur', $promoteur)
    ->get();
    # Liste des demandes traitées
    $processedDemandes = App\Models\DemandeTraitee::select('demande_traitees.*')
    ->join('demandes', 'demandes.id_demande', '=', 'demande_traitees.id_demande')
    ->where('demandes.id_statut_demande', 6)
    ->where('demandes.id_promoteur', $promoteur)
    ->get();
    }
@endphp
<nav class="navbar navbar-expand-sm navbar-light fixed-top bg-primary">
    <div class="container">
        <a class="navbar-brand" href="{{ route('home') }}">
            <img id="logo-anime" src="{{ url('assets/images/logos/logo_plaged.png') }}" width="200" alt="">
        </a>
        <button class="navbar-toggler d-lg-none" type="button" data-bs-toggle="collapse"
            data-bs-target="#collapsibleNavId" aria-controls="collapsibleNavId" aria-expanded="false"
            aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="collapsibleNavId">
            <ul class="navbar-nav mx-auto mt-2 mt-lg-0">
                <li class="nav-item">
                    <a class="nav-link {{ Route::is('home') ? 'active' : '' }}" href="{{ route('home') }}"
                        aria-current="page">
                        Accueil
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ Route::is('guide.to.procedures') ? 'active' : '' }}"
                        href="{{ route('guide.to.procedures') }}" aria-current="page">
                        Guide des démarches
                    </a>
                </li>
                @auth
                @if (!auth()->user()->hasAnyRole(Admin::getAllImportantRoles()))
                <li class="nav-item">
                    <a class="nav-link {{ Route::is('demande.add') ? 'active' : '' }}"
                        href="{{ route('demande.add') }}">
                        Faire une demande
                    </a>
                </li>
                <li class="nav-item">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle {{ Route::is('demande.index') || Route::is('demande.category') ? 'active' : '' }}"
                        href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Mes demandes <span class="text-danger" style="position: relative; top: -5px; font-size: 14px;">{{ $allDemandes->count() > 0 ? '('.$allDemandes->count().')' : '' }}</span>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="{{ route('demande.index') }}">Toutes les demandes ({{
                                $allDemandes->count() }})</a></li>
                        <li><a class="dropdown-item" href="{{ route('demande.category', 'processing') }}">En attente de
                                traitement ({{
                                $awaitingProcessingDemandes->count() }})</a></li>
                        <li><a class="dropdown-item" href="{{ route('demande.category', 'study') }}">En attente d'étude
                                ({{ $awaitingStudyDemandes->count()
                                }})</a></li>
                        <li><a class="dropdown-item" href="{{ route('demande.category', 'review') }}">En attente
                                d'examnen ({{ $awaitingReviewDemandes->count()
                                }})</a></li>
                        <li><a class="dropdown-item" href="{{ route('demande.category', 'modification') }}">En attente
                                de motification ({{
                                $awaitingModificationDemandes->count() }})</a></li>
                        <li><a class="dropdown-item" href="{{ route('demande.category', 'rejected') }}">Rejetées ({{
                                $rejectedDemandes->count() }})</a></li>
                        <li><a class="dropdown-item" href="{{ route('demande.category', 'processed') }}">Traitées ({{
                                $processedDemandes->count() }})</a></li>
                    </ul>
                </li>
                {{-- <li class="nav-item">
                    <a class="nav-link {{ Route::is('demande.index') ? 'active' : '' }}"
                        href="{{ route('demande.index') }}">
                        Mes demandes
                    </a>
                </li> --}}
                @endif
                @hasanyrole(Admin::getAllImportantRoles())
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('dashboard') }}">Dashboard</a>
                </li>
                @endhasanyrole
                @endauth
                <li class="nav-item">
                    <a class="nav-link {{ Route::is('contact.us') ? 'active' : '' }}" href="{{ route('contact.us') }}"
                        aria-current="page">
                        Contact
                    </a>
                </li>
            </ul>
            @auth
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
                    <img class="rounded-circle me-lg-2" src="{{ url('assets/images/profile-pictures/user.png') }}"
                        alt="" style="width: 40px; height: 40px;">
                    <span class="d-none d-lg-inline-flex">{{ auth()->user()->first_name }}</span>
                </a>
                <div class="dropdown-menu border-0 rounded-0 rounded-bottom m-0">
                    <a href="#" class="dropdown-item px-2 nav-link text-dark text-center"
                        onclick="window.location.href = '/logout'">
                        Se déconnecter
                    </a>
                    {{-- <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                        @csrf
                    </form>
                    <a href="{{ route('logout') }}" class="dropdown-item px-2 nav-link text-dark"
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        Se déconnecter
                    </a> --}}
                </div>
            </div>
            @else
            <ul class="navbar-nav mr-auto mt-2 mt-lg-0">
                @if (!Route::is('login'))
                <li class="nav-item">
                    <a class="btn btn-secondary me-2" href="{{ route('login') }}">
                        Se connecter
                    </a>
                </li>
                @endif
                @if (!Route::is('register'))
                <li class="nav-item">
                    <a class="btn btn-secondary me-2" href="{{ route('register') }}">
                        S'inscrire
                    </a>
                </li>
                @endif
            </ul>
            @endauth
        </div>
    </div>
</nav>