<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <meta name="description" content="">
	    <meta name="author" content="Ministère du Commerce de l'Industrie et des PME">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <link rel="icon" href="{{ url('assets/images/logos/armoirerie.png') }}">

	    <title>{{ config('app.name', '') }} - @yield('title')</title>
        
        <!-- Bootstrap CSS -->
        <link href="{{ url('bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">

        <!-- Fonts Awesome -->
        <link rel="stylesheet" href="{{ url('assets/css/font-awesome.css') }}">
        <script src="{{ url('assets/js/kit.fontawesome.js') }}"></script>

        <!-- Core CSS -->
	    <link rel="stylesheet" href="{{ url('assets/css/aos.css') }}">
        
        <!-- Sweetalert2  CSS -->
        <link rel="stylesheet" href="{{ url('assets/css/sweetalert2.min.css') }}">
        
        <!-- Custom CSS -->
        <link rel="stylesheet" href="{{ url('assets/css/main.css') }}">
        <link rel="stylesheet" href="{{ url('assets/css/slider.css') }}">
        
        <!-- Spinner CSS -->
        <link rel="stylesheet" href="{{ url('assets/css/spinner.css') }}">

        <!-- DataTables  CSS -->
        <link rel="stylesheet" href="{{ url('dataTables/css/datatables.min.css') }}">
    </head>
    <body style="margin-top: 92px; padding: 0 !important">
        @include('frontend.layouts.inc._spinner')
        <div class="p-0" style="min-height: 100vh;">
            <!-- Navbar -->
            @include('frontend.layouts.inc._navbar')
            @if (!Route::is('home'))
                <!-- Banner -->
                <div class="p-2 text-center" style="background: url({{ url('assets/images/banners/banner-3.png') }})">
                    <img src="{{ url('assets/images/logos/branding_guinee.png') }}" width="90" alt="">
                </div>
            @endif
            @if (Route::is('home'))
                <!-- Slider -->
                @include('frontend.layouts.inc._slider')
            @endif
            <main>
                @yield('content')
            </main>
            <!-- Footer -->
            @include('frontend.layouts.inc._footer')
        </div>

        <!-- Jquery 3.7.1 -->
	    <script src="{{ url('assets/js/jquery-3.7.1.min.js') }}"></script>

        <!-- Core JS -->
        <script src="{{ url('assets/js/aos.js') }}"></script>
        <script src="{{ url('ckeditor5/ckeditor.js') }}"></script>

        <!-- Bootstrap JS -->
        <script src="{{ url('bootstrap/js/bootstrap.bundle.min.js') }}"></script>

        <!-- Custom JS -->
        <script src="{{ url('assets/js/main.js') }}"></script>
        <!-- Spinner JS -->
        <script src="{{ url('assets/js/spinner.js') }}"></script>

        <!-- Sweetalert2 JS -->
        <script src="{{ url('assets/js/sweetalert2.all.min.js') }}"></script>

        <!-- CKEditor -->
        <script src="{{ url('ckeditor5/ckeditor.js') }}"></script>

        <!-- CKEditor Configuration -->
        <script>
            ClassicEditor
                .create(document.querySelector( '#ckeditor' ), {
                    toolbar: {
                        items: [
                            'exportPDF','exportWord', '|',
                            'findAndReplace', 'selectAll', '|',
                            'heading', '|',
                            'bold', 'italic', 'strikethrough', 'underline', 'code', 'subscript', 'superscript', 'removeFormat', '|',
                            'bulletedList', 'numberedList', 'todoList', '|',
                            'outdent', 'indent', '|',
                            'undo', 'redo',
                            '-',
                            'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor', 'highlight', '|',
                            'alignment', '|',
                            'link', 'insertImage', 'blockQuote', 'insertTable', 'mediaEmbed', 'codeBlock', 'htmlEmbed', '|',
                            'specialCharacters', 'horizontalLine', 'pageBreak', '|',
                            'textPartLanguage', '|',
                            'sourceEditing'
                        ],
                        shouldNotGroupWhenFull: false
                    },
                    fontFamily: {
                        options: [
                            'default',
                            'Arial, Helvetica, sans-serif',
                            'Courier New, Courier, monospace',
                            'Georgia, serif',
                            'Lucida Sans Unicode, Lucida Grande, sans-serif',
                            'Tahoma, Geneva, sans-serif',
                            'Times New Roman, Times, serif',
                            'Trebuchet MS, Helvetica, sans-serif',
                            'Verdana, Geneva, sans-serif'
                        ],
                        supportAllValues: true
                    },
                    fontSize: {
                        options: [ 10, 12, 14, 'default', 18, 20, 22 ],
                        supportAllValues: true
                    },
                    ckfinder: {
                        uploadUrl: "",
                        options: {
                            resourceType: 'Images'
                        }
                    }                    
                })
                .then(editor => {
                    console.log(editor);
                })
                .catch(error => {
                    console.error(error);
                }
            );
        </script>

        <!-- DataTables  JS -->
        <script src="{{ url('dataTables/js/datatables.min.js') }}"></script>
        <script src="{{ url('dataTables/js/pdfmake.min.js') }}"></script>
        <script src="{{ url('dataTables/js/vfs_fonts.js') }}"></script>

        <script>
            new DataTable('.dataTables');
        </script>

        <!-- Information Message -->
        @if (session()->has('info'))
            <script>
                Swal.fire({
                    // title: "Information!",
                    text: "{!!session()->get('info')!!}",
                    icon: "info",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        @endif
        <!-- Success Message -->
        @if (session()->has('success'))
            <script>
                Swal.fire({
                    // title: "Success!",
                    text: "{!!session()->get('success')!!}",
                    icon: "success",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        @endif
        <!-- Warning Message -->
        @if (session()->has('warning'))
            <script>
                Swal.fire({
                    // title: "Warning!",
                    text: "{!!session()->get('warning')!!}",
                    icon: "warning",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        @endif
        <!-- Error Message -->
        @if (session()->has('error'))
            <script>
                Swal.fire({
                    // title: "Error!",
                    text: "{!!session()->get('error')!!}",
                    icon: "error",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        @endif

        <!-- AOS JS -->
        <script>
            AOS.init();
        </script>
        
        <!-- Auto Log Out -->
        @auth
            <script src="{{ url('session.js') }}"></script>
        @endauth
    </body>
</html>