@extends('backend.layouts.admin')

@section('title', 'User Privileges')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <!-- User detail -->
            <div class="text-center">
                <h3 class="bg-primary rounded p-3 mb-4 text-center">Informations de l'Utilisateur</h3>
            </div>
            <div class="col-12">
                <a class="btn btn-light float-end" href="{{ route('admin.user.list') }}"><i class="fa fa-arrow-circle-left">&nbsp;List of Users</i></a>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">Prénom</th>
                                    <th scope="col">Nom</th>
                                    <th scope="col">Email</th>
                                    <th scope="col">Image</th>
                                </tr>
                            </thead>
                            <tbody>
                                @isset($user)
                                    <tr>
                                        <td scope="row">{{ $user->first_name }}</td>
                                        <td>{{ $user->last_name }}</td>
                                        <td>{{ $user->email }}</td>
                                        <td class="text-center">
                                            @if ($user->profile_picture != NULL)
                                                <img src="{{ url('storage/profile-picture/'.$user->profile_picture.'') }}" class="rounded-circle" width="50" height="50" alt="">
                                            @endif
                                            <img src="{{ url('storage/profile-picture/user.png') }}" class="rounded-circle" width="50" height="50" alt="">
                                        </td>
                                    </tr>
                                @endisset
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- User Roles -->
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <h6 class="mb-4 text-center">Rôles de l'Utilisateur</h6>
                        <div class="text-center">
                            <form action="{{ route('admin.user.assign.role', $user->user_id) }}" method="post">
                                @csrf
                                <div class="row">
                                    <div class="col-6 offset-3">
                                        <div class="form-floating mb-3">
                                            <select name="role_name" class="form-select @error('role_name') is-invalid @enderror" id="floatingSelect">
                                                <option value="">Sélectionner un rôle</option>
                                                @if (isset($roles))
                                                    @foreach ($roles as $role)
                                                        <option value="{{ $role->name }}">{{ $role->name }}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            <label for="floatingSelect">Liste des Rôles</label>
                                            @error('role_name')
                                                <span class="invalid-feedback" role="alert">
                                                    {{ $message }}
                                                </span>
                                            @enderror
                                        </div>
                                        <button type="submit" class="btn btn-primary mb-4"><i class="fa fa-save me-2"></i>Assigner le rôle</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th scope="col">Nom du rôle</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @isset($user->roles)
                                    @foreach ($user->roles as $role)
                                        <tr>
                                            <td scope="row">{{ $role->name }}</td>
                                            <td>
                                                <a class="btn btn-danger" href="#" onclick="removeRole({{ $user->user_id }}, {{ $role->id }})">Retiré le rôle</a>
                                            </td>
                                        </tr>
                                        <script>
                                            function removeRole(user, role) {
                                                Swal.fire({
                                                    title: "Es-tu sûr?",
                                                    text: "You won't be able to revert this!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Yes, delete it!"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('admin.user.remove.role', [':user', ':role']) }}".replace(':user', user).replace(':role', role);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endisset
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- User Permissions -->
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <h6 class="mb-4 text-center">Privilèges de l'Utilisateur</h6>
                        <div class="text-center">
                            <form action="{{ route('admin.user.grant.permission', $user->user_id) }}" method="post">
                                @csrf
                                <div class="row">
                                    <div class="col-6 offset-3">
                                        <div class="form-floating mb-3">
                                            <select name="permission_name" class="form-select @error('permission_name') is-invalid @enderror" id="floatingSelect">
                                                <option value="">Sélectionner un Privilège</option>
                                                @if (isset($permissions))
                                                    @foreach ($permissions as $permission)
                                                        <option value="{{ $permission->name }}">{{ $permission->name }}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            <label for="floatingSelect">Liste des Privilèges</label>
                                            @error('permission_name')
                                                <span class="invalid-feedback" role="alert">
                                                    {{ $message }}
                                                </span>
                                            @enderror
                                        </div>
                                        <button type="submit" class="btn btn-primary mb-4"><i class="fa fa-save me-2"></i>Accorder le privilège</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th scope="col">Nom du Privilège</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @isset($user->permissions)
                                    @foreach ($user->permissions as $i => $permission)
                                        <tr>
                                            <td scope="row">{{ $permission->name }}</td>
                                            <td>
                                                <a class="btn btn-danger" href="#" onclick="revokePermission({{ $user->user_id }}, {{ $permission->id }})">Retirer la privilège</a>
                                            </td>
                                        </tr>
                                        <script>
                                            function revokePermission(user, permission) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('admin.user.revoke.permission', [':user', ':permission']) }}".replace(':user', user).replace(':permission', permission);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endisset
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection