@extends('backend.layouts.admin')

@section('title', 'Liste des Utilisateurs')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">Liste des Utilisateurs</h3>
                </div>
            </div>
            <div class="row">
                <div class="text-center">
                    <a class="btn btn-light" href="{{ route('admin.user.add') }}"><i class="fa fa-plus-circle">&nbsp;Ajout Utilisateur</i></a>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">#</th>
                                    <th scope="col">Prénom</th>
                                    <th scope="col">Nom</th>
                                    <th scope="col">Email</th>
                                    <th scope="col">Photo</th>
                                    <th scope="col">Rôle</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @isset($users)
                                    @foreach ($users as $i => $user)
                                        <tr>
                                            <th scope="row">{{ ($i+1) }}</th>
                                            <td>{{ $user->first_name }}</td>
                                            <td>{{ $user->last_name }}</td>
                                            <td>{{ $user->email }}</td>
                                            <td class="text-center">
                                                @if ($user->profile_picture != NULL)
                                                    <img src="{{ url('storage/profile-picture/'.$user->profile_picture.'') }}" class="rounded-circle" width="50" height="50" alt="">
                                                @endif
                                                <img src="{{ url('assets/images/profile-pictures/user.png') }}" class="rounded-circle" width="50" height="50" alt="">
                                            </td>
                                            <td>
                                                @if ($user->roles && $user->roles->count() > 0)
                                                    @foreach ($user->roles as $role)
                                                        <span class="text-success fw-bold text-uppercase">{{ $role->name }}</span>@if(!$loop->last),<br>@endif
                                                    @endforeach
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a class="btn btn-warning" href="{{ route('admin.user.edit', $user->user_id) }}">Modifier</a>
                                                    <a class="btn btn-info" href="{{ route('admin.user.details', $user->user_id) }}">Accorder Privilèges</a>
                                                    <a class="btn btn-danger" href="#" onclick="removeUser({{ $user->user_id }})">Suppirmer</a>
                                                </div>
                                            </td>
                                        </tr>
                                        <script>
                                            function removeUser(user) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!",
                                                    cancelButtonText: "Annuler"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('admin.user.delete', ':user') }}".replace(':user', user);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endisset
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection