@extends('backend.layouts.admin')

@section('title', 'Modification Utilisateur')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="index.html">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Modification Utilisateur</h5>
                    </div>
                    <form action="{{ route('admin.user.update', $user->user_id) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <div class="row">
                            <!-- Email -->
                            <div class="col-12">
                                <div class="form-floating mb-3">
                                    <input type="hidden" name="email" value="{{ old('email') ?? $user->email }}">
                                    <input @disabled(true) value="{{ old('email') ?? $user->email }}" class="form-control bg-secondary @error('email') is-invalid @enderror" id="floatingInput" placeholder="name@example.com">
                                    <label for="floatingInput">Adresse Email</label>
                                    @error('email')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>                        
                        </div>
                        <div class="row">
                            <!-- First Name -->
                            <div class="col-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="first_name" value="{{ old('first_name') ?? $user->first_name }}" class="form-control @error('first_name') is-invalid @enderror" id="floatingText" placeholder="Mamadi">
                                    <label for="floatingText">Prénom :</label>
                                    @error('first_name')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- Last Name -->
                            <div class="col-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="last_name" value="{{ old('last_name') ?? $user->last_name }}" class="form-control @error('last_name') is-invalid @enderror" id="floatingText" placeholder="CISSE">
                                    <label for="floatingText">Nom :</label>
                                    @error('last_name')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>                        
                        <div class="row">
                            <!-- Password -->
                            <div class="col-6">
                                <div class="form-floating mb-3">
                                    <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" id="floatingPassword" placeholder="Password">
                                    <label for="floatingPassword">Mot de passe :</label>
                                    @error('password')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- Confirm Password -->
                            <div class="col-6">
                                <div class="form-floating mb-3">
                                    <input type="password" name="password_confirmation" class="form-control @error('password_confirmation') is-invalid @enderror" id="floatingPassword" placeholder="Confirm Password">
                                    <label for="floatingPassword">Confirmer le mot de passe :</label>
                                    @error('password_confirmation')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Mettre à jour</button>
                            </div>
                            <div class="text-center">
                                <a class="text-white text-decoration-underline" href="{{ route('admin.user.list') }}">Retour à la liste des utilisateurs</a>                            
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection