@extends('backend.layouts.admin')

@section('title', 'Ajout Utilisateur')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="{{ route('dashboard') }}" class="">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Ajout Utilisateur</h5>
                    </div>
                    <form action="{{ route('admin.user.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <!-- First Name -->
                            <div class="col-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="first_name" value="{{ old('first_name') }}" class="form-control @error('first_name') is-invalid @enderror" id="floatingText" placeholder="Mamadi">
                                    <label for="floatingText">Prénom : *</label>
                                    @error('first_name')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- Last Name -->
                            <div class="col-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="last_name" value="{{ old('last_name') }}" class="form-control @error('last_name') is-invalid @enderror" id="floatingText" placeholder="CISSE">
                                    <label for="floatingText">Nom : *</label>
                                    @error('last_name')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <!-- Email -->
                            <div class="col-6">
                                <div class="form-floating mb-3">
                                    <input type="email" name="email" value="{{ old('email') }}" class="form-control @error('email') is-invalid @enderror" id="floatingInput" placeholder="name@example.com">
                                    <label for="floatingInput">Email : *</label>
                                    @error('email')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>           
                            <!-- Telephone -->
                            <div class="col-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="telephone" value="{{ old('telephone') }}" class="form-control @error('telephone') is-invalid @enderror" id="floatingInput" placeholder="600000000">
                                    <label for="floatingInput">Téléphone : *</label>
                                    @error('telephone')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>                        
                        </div>
                        <div class="row">
                            <!-- Address -->
                            <div class="col-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="address" value="{{ old('address') }}" class="form-control @error('address') is-invalid @enderror" placeholder="Conakry" style="height:58px;line-height:1.25;">
                                    <label for="floatingPassword">Adresse :</label>
                                    @error('address')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- Gender -->
                            <div class="col-6">
                                <div class="mb-3">
                                    <select name="gender" class="form-select @error('gender') is-invalid @enderror" style="height:58px;line-height:1.25;">
                                        <option value="">Genre : *</option>
                                        @isset($genders)
                                            @foreach ($genders as $gender)
                                                <option {{ old('gender') == $gender->id_genre ? 'selected' : '' }} value="{{ $gender->id_genre }}">{{ $gender->libelle }} </option>
                                            @endforeach                                                
                                        @endisset
                                    </select>
                                    @error('gender')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <!-- User Category -->
                            <div class="col-6">
                                <div class="mb-3">
                                    <select name="user_category" class="form-select @error('user_category') is-invalid @enderror" style="height:58px;line-height:1.25;">
                                        <option value="">Catégorie Utilisateur : *</option>
                                        @isset($userCategories)
                                            @foreach ($userCategories as $userCategory)
                                                <option {{ old('user_category') == $userCategory->id_categorie_utilisateur ? 'selected' : '' }} value="{{ $userCategory->id_categorie_utilisateur }}">{{ $userCategory->libelle }}</option>
                                            @endforeach
                                        @endisset
                                    </select>
                                    @error('user_category')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- Role Name -->
                            <div class="col-6">
                                <div class="mb-3">
                                    <select name="role_name" class="form-select @error('role_name') is-invalid @enderror" style="height:58px;line-height:1.25;">
                                        <option value="">Sélectionner un rôle :</option>
                                        @if (isset($roles))
                                            @foreach ($roles as $role)
                                                <option {{ old('role_name') == $role->name ? 'selected' : '' }} value="{{ $role->name }}">{{ $role->name }}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                    @error('role_name')
                                        <span class="invalid-feedback" role="alert">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <!-- Password -->
                            <div class="col-6">
                                <div class="form-floating mb-3">
                                    <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" id="floatingPassword" placeholder="Password">
                                    <label for="floatingPassword">Mot de passe :</label>
                                    @error('password')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- Confirm Password -->
                            <div class="col-6">
                                <div class="form-floating mb-3">
                                    <input type="password" name="password_confirmation" class="form-control @error('password_confirmation') is-invalid @enderror" id="floatingPassword" placeholder="Confirm Password">
                                    <label for="floatingPassword">Confirmer le mot de passe :</label>
                                    @error('password_confirmation')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Ajouter l'Utilisateur</button>
                            </div>
                            <div class="text-center">
                                <a class="text-white text-decoration-underline" href="{{ route('admin.user.list') }}">Retour à la liste des utilisateurs</a>                            
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection