@extends('backend.layouts.admin')

@section('title', 'List des types de document')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">Liste des types documents</h3>
                </div>
            </div>
            <div class="row">
                <div class="text-center">
                    <a class="btn btn-light" href="{{ route('type_document.create') }}"><i class="fa fa-plus-circle">&nbsp;Ajouter un type de document</i></a>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">#</th>
                                    <th scope="col">Type</th>
                                    <th scope="col">Montant</th>
                                    <th scope="col">Catégorie</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($types->isEmpty())
                                        <tr>
                                            <td colspan="7" class="text-center">Aucun type de document trouvé.</td>
                                        </tr>
                                @else
                                    @foreach ($types as $i => $type)
                                        <tr>
                                            <th scope="row">{{ ($i+1) }}</th>
                                            <td>{{ $type->libelle }}</td>
                                            <td>{{ number_format($type->montant, 0, ',', ' ') }} GNF</td>
                                            <td>{{ $type->categorieDocument->libelle }}</td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a class="btn btn-warning" style="border-radius: 50%;" href="{{ route('type_document.edit', $type) }}"><i class="fa fa-pencil"></i></a> &nbsp;&nbsp;
                                                    <a class="btn btn-danger" style="border-radius: 50%;" href="#" onclick="deleteType({{ $type->id_type_document }})"><i class="fa fa-trash"></i></a>
                                                </div>
                                            </td>
                                        </tr>
                                        <script>
                                            function deleteType(type) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('type_document.delete', ':type') }}".replace(':type', type);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        {{ $types->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection