@extends('backend.layouts.admin')

@section('title', 'Add type document')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="{{ route('dashboard') }}" class="">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Ajout de type de document</h5>
                    </div>
                    <form action="{{ route('type_document.store') }}" method="POST">
                        @csrf
                        @method('POST')

                        <!-- Promoteur Name -->
                        <div class="form-floating mb-3">
                            <input type="text" name="libelle" value="{{ old('libelle') }}" class="form-control @error('libelle') is-invalid @enderror" id="floatingText" placeholder="Type de document...">
                            <label for="floatingText">Type de document</label>
                            @error('libelle')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>   
                         <!-- Promoteur Name -->
                         <div class="form-floating mb-3">
                            <input type="text" name="montant" value="{{ old('montant') }}" class="form-control @error('montant') is-invalid @enderror" id="floatingText" placeholder="Montant...">
                            <label for="floatingText">Montant</label>
                            @error('montant')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>    
                         <!-- Categorie -->
                         <div class="mb-3">
                            <select name="id_categorie_document" class="form-select @error('id_categorie_document') is-invalid @enderror" style="height:58px;line-height:1.25;">
                                <option value="">--Choisissez la catégorie--</option>
                                @foreach ($categories as $category)
                                    <option {{ old('id_categorie_document') == $category->id_categorie_document ? 'selected' : '' }} value="{{ $category->id_categorie_document }}">{{ $category->libelle }}</option>
                                @endforeach
                            </select>
                            @error('id_categorie_document')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>                    
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Ajouter le type de document</button>
                        </div>
                        <div class="text-center">
                            <a class="text-white text-decoration-underline" href="{{ route('type_document.index') }}">Retour à la liste des types de document</a>                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection