@extends('backend.layouts.admin')

@section('title', 'List des entités sources')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">Liste des services</h3>
                </div>
            </div>
            <div class="row">
                <div class="text-center">
                    <a class="btn btn-light" href="{{ route('service.create') }}"><i class="fa fa-plus-circle">&nbsp;Ajouter un service</i></a>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">#</th>
                                    <th scope="col">Direction</th>
                                    <th scope="col">Nom</th>
                                    <th scope="col">E-mail</th>
                                    <th scope="col">Téléphone</th>
                                    <th scope="col">Localisation</th>
                                    <th scope="col">Mission</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @isset($services)
                                    @foreach ($services as $i => $service)
                                        <tr>
                                            <th scope="row">{{ ($i+1) }}</th>
                                            <td>{{ $service->direction->nom }}</td>
                                            <td>{{ $service->nom }}</td>
                                            <td>{{ $service->email }}</td>
                                            <td>{{ $service->telephone }}</td>
                                            <td>{{ $service->localisation }}</td>
                                            <td>{{ $service->mission }}</td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a class="btn btn-warning" href="{{ route('service.edit', $service) }}">Modifier</a>
                                                    <a class="btn btn-danger" href="#" onclick="deleteMinister({{ $service->id_service }})">Supprimer</a>
                                                </div>
                                            </td>
                                        </tr>
                                        <script>
                                            function deleteMinister(service) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('service.delete', ':service') }}".replace(':service', service);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endisset
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        {{ $services->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection