@extends('backend.layouts.admin')

@section('title', 'Add Role')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="{{ route('dashboard') }}" class="">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Modification du service</h5>
                    </div>
                    <form action="{{ route('service.update', $service) }}" method="POST">
                        @csrf
                        @method('PUT')
                         <!-- Entity Type -->
                         <div class="mb-3">
                            <select name="id_direction" class="form-select @error('id_direction') is-invalid @enderror" style="height:58px;line-height:1.25;">
                                <option value="" disabled>--Choisissez la direction--</option>
                                @foreach ($directions as $direction)
                                    <option value="{{ $direction->id_direction }}" {{$service->id_direction === $direction->id_direction ? "selected": ""}}>{{ $direction->nom }}</option>
                                @endforeach
                            </select>
                            @error('id_ministere')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <!-- Minister Name -->
                        <div class="form-floating mb-3">
                            <input type="text" name="nom" value="{{$service->nom}}" class="form-control @error('nom') is-invalid @enderror" id="floatingText" placeholder="Nom de la direction...">
                            <label for="floatingText">Nom du service</label>
                            @error('nom')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>

                         <!-- Minister Name -->
                         <div class="form-floating mb-3">
                            <input type="email" name="email" value="{{$service->email}}" class="form-control @error('email') is-invalid @enderror" id="floatingText" placeholder="E-mail de la direction...">
                            <label for="floatingText">E-mail du service</label>
                            @error('email')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                         <!-- Minister Phone -->
                         <div class="form-floating mb-3">
                            <input type="text" name="telephone" value="{{$service->telephone}}" class="form-control @error('telephone') is-invalid @enderror" id="floatingText" placeholder="Téléphone de la direction...">
                            <label for="floatingText">Téléphone du service</label>
                            @error('telephone')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                         <!-- Service Location -->
                         <div class="form-floating mb-3">
                            <input type="text" name="localisation" value="{{$service->localisation}}" class="form-control @error('localisation') is-invalid @enderror" id="floatingText" placeholder="Localisation de la direction...">
                            <label for="floatingText">Localisation du service</label>
                            @error('localisation')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                       
                         
                        <!-- service mission -->
                        <div class="form-floating mb-3">
                            <input type="text" name="mission" value="{{ $service->mission }}" class="form-control @error('mission') is-invalid @enderror" id="floatingText" placeholder="Mission du ministère...">
                            <label for="floatingText">Mission du service</label>
                            @error('mission')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Modifier le service</button>
                        </div>
                        <div class="text-center">
                            <a class="text-white text-decoration-underline" href="{{ route('service.index') }}">Retour à la liste des services</a>                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection