@extends('backend.layouts.admin')

@section('title', 'Role Permissions')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <!-- User Permissions -->
            <div class="text-center">
                <h3 class="bg-primary rounded p-3 mb-4 text-center">Informations de l'Utilisateur</h3>
            </div>
            <div class="col-12">
                <a class="btn btn-light float-end" href="{{ route('admin.role.list') }}"><i class="fa fa-arrow-circle-left">&nbsp;List of Roles</i></a>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <h6 class="mb-4 text-center">Les Privilèges du Rpele</h6>
                        <div class="row">
                            <div class="col-xl-3 col-sm-12">
                                <div class="text-center">
                                    <form action="{{ route('admin.role.grant.permission', $role->id) }}" method="post">
                                        @csrf
                                        <div class="border rounded p-2">
                                            <h6>Accorder un privilège</h6>
                                            <div class="mb-3">
                                                <select name="permission_name" class="form-select @error('permission_name') is-invalid @enderror" id="floatingSelect">
                                                    <option value="">Sélectionner un privilège</option>
                                                    @if (isset($permissions))
                                                        @foreach ($permissions as $permission)
                                                            <option value="{{ $permission->name }}">{{ $permission->name }}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                                @error('permission_name')
                                                    <span class="invalid-feedback" role="alert">
                                                        {{ $message }}
                                                    </span>
                                                @enderror
                                            </div>
                                            <button type="submit" class="btn btn-primary"><i class="fa fa-check me-2"></i>Grant</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="col-xl-9 col-sm-12">
                                <table class="table table-bordered table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th scope="col">Nom Privilège</th>
                                            <th scope="col">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @isset($role->permissions)
                                            @foreach ($role->permissions as $i => $permission)
                                                <tr>
                                                    <td>{{ ($i + 1) }}</td>
                                                    <td scope="row">{{ $permission->name }}</td>
                                                    <td>
                                                        <a class="btn btn-danger" href="#" onclick="revokePermission({{ $role->id }}, {{ $permission->id }})">Retirer</a>
                                                    </td>
                                                </tr>
                                                <script>
                                                    function revokePermission(role, permission) {
                                                        Swal.fire({
                                                            title: "Are you sure?",
                                                            text: "You won't be able to revert this!",
                                                            icon: "warning",
                                                            showCancelButton: true,
                                                            confirmButtonColor: "#3085d6",
                                                            cancelButtonColor: "#d33",
                                                            confirmButtonText: "Yes, delete it!"
                                                        }).then((result) => {
                                                            if (result.isConfirmed) {
                                                                window.location = "{{ route('admin.role.revoke.permission', [':role', ':permission']) }}".replace(':role', role).replace(':permission', permission);
                                                            }
                                                        });
                                                    }
                                                </script>
                                            @endforeach
                                        @endisset
                                    </tbody>
                                </table>
                            </div>
                        </div>     

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection