@extends('backend.layouts.admin')

@section('title', 'List of roles')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">List of Roles</h3>
                </div>
            </div>
            <div class="row">
                <div class="text-center">
                    <a class="btn btn-light" href="{{ route('admin.role.add') }}"><i class="fa fa-plus-circle">&nbsp;Add Role</i></a>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">#</th>
                                    <th scope="col">Role Name</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @isset($roles)
                                    @foreach ($roles as $i => $role)
                                        <tr>
                                            <th scope="row">{{ ($i+1) }}</th>
                                            <td>{{ $role->name }}</td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    @if ($role->name != 'super_admin')
                                                        <a class="btn btn-warning" href="{{ route('admin.role.edit', $role->id) }}">Edit</a>
                                                    @endif
                                                    <a class="btn btn-info" href="{{ route('admin.role.details', $role->id) }}">Permissions</a>
                                                    @if ($role->name != 'super_admin')
                                                        <a class="btn btn-danger" href="#" onclick="deleteUser({{ $role->id }})">Remove</a>
                                                    @endif
                                                </div>
                                            </td>
                                        </tr>
                                        <script>
                                            function deleteUser(role) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!",
                                                    cancelButtonText: "Annuler"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('admin.role.delete', ':role') }}".replace(':role', role);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endisset
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection