@extends('backend.layouts.admin')

@section('title', 'List des entités sources')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">Liste des responsables</h3>
                </div>
            </div>
            <div class="row">
                <div class="text-center">
                    <a class="btn btn-light" href="{{ route('responsable.create') }}"><i class="fa fa-plus-circle">&nbsp;Ajouter un responsable</i></a>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">#</th>
                                    <th scope="col">Nom</th>
                                    <th scope="col">Prenom</th>
                                    <th scope="col">E-mail</th>
                                    <th scope="col">Téléphone</th>
                                    <th scope="col">Adresse</th>
                                    <th scope="col">Fonction</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($responsables->isEmpty())
                                        <tr>
                                            <td colspan="7" class="text-center">Aucun responsable trouvé.</td>
                                        </tr>
                                @else
                                    @foreach ($responsables as $i => $responsable)
                                        <tr>
                                            <th scope="row">{{ ($i+1) }}</th>
                                            <td>{{ $responsable->nom }}</td>
                                            <td>{{ $responsable->prenom }}</td>
                                            <td>{{ $responsable->email }}</td>
                                            <td>{{ $responsable->telephone }}</td>
                                            <td>{{ $responsable->adresse }}</td>
                                            <td>{{ $responsable->fonction->libelle}}</td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a class="btn btn-warning" href="{{ route('responsable.edit', $responsable) }}">Modifier</a>
                                                    <a class="btn btn-danger" href="#" onclick="deleteMinister({{ $responsable->id_responsable }})">Supprimer</a>
                                                </div>
                                            </td>
                                        </tr>
                                        <script>
                                            function deleteMinister(responsable) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('responsable.delete', ':responsable') }}".replace(':responsable', responsable);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        {{ $responsables->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection