@extends('backend.layouts.admin')

@section('title', 'Add Role')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="{{ route('dashboard') }}" class="">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Modification des infos du responsable</h5>
                    </div>
                    <form action="{{ route('responsable.update', $responsable) }}" method="POST">
                        @csrf
                        @method('PUT')
                         
                        <!-- responsable Name -->
                        <div class="form-floating mb-3">
                            <input type="text" name="nom" value="{{$responsable->nom}}" class="form-control @error('nom') is-invalid @enderror" id="floatingText" placeholder="Nom du responsable...">
                            <label for="floatingText">Nom du responsable</label>
                            @error('nom')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>

                        <!-- responsable Name -->
                        <div class="form-floating mb-3">
                            <input type="text" name="prenom" value="{{$responsable->prenom}}" class="form-control @error('prenom') is-invalid @enderror" id="floatingText" placeholder="Prenom du responsable...">
                            <label for="floatingText">Prenom du responsable</label>
                            @error('prenom')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>

                         <!-- Minister Name -->
                         <div class="form-floating mb-3">
                            <input type="email" name="email" value="{{$responsable->email}}" class="form-control @error('email') is-invalid @enderror" id="floatingText" placeholder="E-mail du responsable...">
                            <label for="floatingText">E-mail du responsable</label>
                            @error('email')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                         <!-- Minister Phone -->
                         <div class="form-floating mb-3">
                            <input type="text" name="telephone" value="{{$responsable->telephone}}" class="form-control @error('telephone') is-invalid @enderror" id="floatingText" placeholder="Téléphone du responsable...">
                            <label for="floatingText">Téléphone du responsable</label>
                            @error('telephone')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                         <!-- Service Location -->
                         <div class="form-floating mb-3">
                            <input type="text" name="adresse" value="{{$responsable->adresse}}" class="form-control @error('adresse') is-invalid @enderror" id="floatingText" placeholder="Adresse du responsable...">
                            <label for="floatingText">Adresse du responsable</label>
                            @error('adresse')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                       
                        <!-- Entity Type -->
                        <div class="mb-3">
                            <select name="id_fonction" class="form-select @error('id_fonction') is-invalid @enderror" style="height:58px;line-height:1.25;">
                                <option value="" disabled>--Choisissez la fonction--</option>
                                @foreach ($fonctions as $fonction)
                                    <option value="{{ $fonction->id_fonction }}" {{$responsable->id_fonction === $fonction->id_fonction ? "selected": ""}}>{{ $fonction->libelle }}</option>
                                @endforeach
                            </select>
                            @error('id_fonction')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Modifier le responsable</button>
                        </div>
                        <div class="text-center">
                            <a class="text-white text-decoration-underline" href="{{ route('responsable.index') }}">Retour à la liste des responsables</a>                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection