@extends('backend.layouts.admin')

@section('title', 'List des entités sources')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">Liste des promoteurs</h3>
                </div>
            </div>
            <div class="row">
                <div class="text-center">
                    <a class="btn btn-light" href="{{ route('promoteur.create') }}"><i class="fa fa-plus-circle">&nbsp;Ajouter un promoteur</i></a>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">#</th>
                                    <th scope="col">Entreprise</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($promoteurs->isEmpty())
                                        <tr>
                                            <td colspan="7" class="text-center">Aucun promoteur trouvé.</td>
                                        </tr>
                                @else
                                    @foreach ($promoteurs as $i => $promoteur)
                                        <tr>
                                            <th scope="row">{{ ($i+1) }}</th>
                                            <td>{{ $promoteur->nom_entreprise }}</td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a class="btn btn-warning" href="{{ route('promoteur.edit', $promoteur) }}">Modifier</a>
                                                    <a class="btn btn-danger" href="#" onclick="deleteMinister({{ $promoteur->id_promoteur }})">Supprimer</a>
                                                </div>
                                            </td>
                                        </tr>
                                        <script>
                                            function deleteMinister(promoteur) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('promoteur.delete', ':promoteur') }}".replace(':promoteur', promoteur);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        {{ $promoteurs->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection