@extends('backend.layouts.admin')

@section('title', 'Add Role')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="{{ route('dashboard') }}" class="">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Ajout de prommoteur</h5>
                    </div>
                    <form action="{{ route('promoteur.store') }}" method="POST">
                        @csrf
                        @method('POST')
                      

                        <!-- Responsable Name -->
                        <div class="form-floating mb-3">
                            <input type="text" name="nom_entreprise" value="{{ old('nom_entreprise') }}" class="form-control @error('nom_entreprise') is-invalid @enderror" id="floatingText" placeholder="Nom de l'entreprise...">
                            <label for="floatingText">Nom de l'entreprise</label>
                            @error('nom_entreprise')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        
                         

                        
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Ajouter le promoteur</button>
                        </div>
                        <div class="text-center">
                            <a class="text-white text-decoration-underline" href="{{ route('promoteur.index') }}">Retour à la liste des promoteurs</a>                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection