@extends('backend.layouts.admin')

@section('title', 'Liste des produits')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">Liste des produits</h3>
                </div>
            </div>
            <div class="row">
                <div class="text-center">
                    <a class="btn btn-light" href="{{ route('produit.create') }}"><i class="fa fa-plus-circle">&nbsp;Ajouter un produit</i></a>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">#</th>
                                    <th scope="col">Nom</th>
                                    <th scope="col">Promoteur</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($produits->isEmpty())
                                        <tr>
                                            <td colspan="7" class="text-center">Aucun produit trouvé.</td>
                                        </tr>
                                @else
                                    @foreach ($produits as $i => $produit)
                                        <tr>
                                            <th scope="row">{{ ($i+1) }}</th>
                                            <td>{{ $produit->nom }}</td>
                                            <td>{{ $produit->promoteur->prenom ?? '' }} {{ $produit->promoteur->nom ?? '' }}</td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a class="btn btn-warning" style="border-radius: 50%;" href="{{ route('produit.edit', $produit) }}"><i class="fa fa-pencil"></i></a> &nbsp;&nbsp;
                                                    <a class="btn btn-danger" style="border-radius: 50%;" href="#" onclick="deleteProduct({{ $produit->id_produit }})"><i class="fa fa-trash"></i></a>
                                                </div>
                                            </td>
                                        </tr>
                                        <script>
                                            function deleteProduct(produit) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('produit.delete', ':produit') }}".replace(':produit', produit);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        {{ $produits->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection