@extends('backend.layouts.admin')

@section('title', 'Add Product')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="{{ route('dashboard') }}" class="">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Ajout de produit</h5>
                    </div>
                    <form action="{{ route('produit.store') }}" method="POST">
                        @csrf
                        @method('POST')

                        <!-- Promoteur Name -->
                        <div class="form-floating mb-3">
                            <input type="text" name="nom" value="{{ old('nom') }}" class="form-control @error('nom') is-invalid @enderror" id="floatingText" placeholder="Nom du produit...">
                            <label for="floatingText">Nom du produit</label>
                            @error('nom')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>    
                         <!-- Categorie -->
                         <div class="mb-3">
                            <select name="id_promoteur" class="form-select @error('id_promoteur') is-invalid @enderror" style="height:58px;line-height:1.25;">
                                <option value="">--Choisissez le promoteur--</option>
                                @foreach ($promoteurs as $promoteur)
                                    <option {{ old('id_promoteur') == $promoteur->id_promoteur ? 'selected' : '' }} value="{{ $promoteur->id_promoteur }}">{{ $promoteur->prenom . ' ' . $promoteur->nom }}</option>
                                @endforeach
                            </select>
                            @error('id_promoteur')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>                    
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Ajouter le produit</button>
                        </div>
                        <div class="text-center">
                            <a class="text-white text-decoration-underline" href="{{ route('produit.index') }}">Retour à la liste des produits</a>                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection