@extends('backend.layouts.admin')

@section('title', 'Liste des Produits')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">Liste des Produits</h3>
                </div>
            </div>
            <div class="row">
                <div class="text-center">
                    <a class="btn btn-light" href="{{ route('admin.product.add') }}"><i class="fa fa-plus-circle">&nbsp;Ajout Produit</i></a>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">#</th>
                                    <th scope="col">Nom Produit</th>
                                    <th scope="col">Description</th>
                                    <th scope="col">Entité Cible</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @isset($products)
                                    @foreach ($products as $i => $product)
                                        <tr>
                                            <th scope="row">{{ ($i+1) }}</th>
                                            <td>{{ $product->product_name }}</td>
                                            <td>{!! $product->description !!}</td>
                                            <td>{{ $product->targetEntity->entity_name }}</td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a class="btn btn-warning" href="{{ route('admin.product.edit', $product->product_id) }}">Modifier</a>
                                                    <a class="btn btn-danger" href="#" onclick="removeProduct({{ $product->product_id }})">Suppirmer</a>
                                                </div>
                                            </td>
                                        </tr>
                                        <script>
                                            function removeProduct(product) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!",
                                                    cancelButtonText: "Annuler"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('admin.product.delete', ':product') }}".replace(':product', product);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endisset
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection