@extends('backend.layouts.admin')

@section('title', 'Modification Produit')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="{{ route('dashboard') }}" class="">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Modification Produit</h5>
                    </div>
                    <form action="{{ route('admin.product.update', $product->product_id) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <!-- Product Name -->
                        <div class="form-floating mb-3">
                            <input type="text" name="product_name" value="{{ old('product_name') ?? $product->product_name }}" class="form-control @error('product_name') is-invalid @enderror" id="floatingText" placeholder="Product Name">
                            <label for="floatingText">Nom Produit :</label>
                            @error('product_name')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <!-- Target Entity Name -->
                        <div class="mb-3">
                            <select style="height: 55px;" name="entity" class="form-select @error('entity') is-invalid @enderror" id="floatingSelect">
                                <option value="">Sélectionner l'entité :</option>
                                @if (isset($entities))
                                    @foreach ($entities as $entity)
                                        <option {{ (old('entity') == $entity->entity_id) || ($product->entity_id == $entity->entity_id) ? 'selected' : '' }} value="{{ $entity->entity_id }}">{{ $entity->entity_name }}</option>
                                    @endforeach
                                @endif
                            </select>
                            @error('entity')
                                <span class="invalid-feedback" role="alert">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <!-- Description -->
                        <div class="mb-3">
                            <textarea name="description" id="ckeditor" cols="30" rows="2" class="form-control" placeholder="Description :">{{ old('description') ?: $product->description  }}</textarea>
                            @error('observation')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Modifier le produit</button>
                        </div>
                        <div class="text-center">
                            <a class="text-white text-decoration-underline" href="{{ route('admin.product.list') }}">Retour à la liste des produits</a>                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection