@extends('backend.layouts.admin')

@section('title', 'List of permissions')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="text-center">
                <h3 class="bg-primary rounded p-3 mb-4">List of Users</h3>
                <div class="col-12">
                    <div class="bg-secondary rounded h-100 p-4">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">First Name</th>
                                        <th scope="col">Last Name</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Picture</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @isset($users)
                                        @foreach ($users as $i => $user)
                                            <tr>
                                                <th scope="row">{{ ($i+1) }}</th>
                                                <td>{{ $user->first_name }}</td>
                                                <td>{{ $user->last_name }}</td>
                                                <td>{{ $user->email }}</td>
                                                <td>
                                                    @if ($user->profile_picture != NULL)
                                                        <img src="{{ url('storage/profile-picture/'.$user->profile_picture.'') }}" class="rounded-circle" width="50" height="50" alt="">
                                                    @endif
                                                    <img src="{{ url('storage/profile-picture/user.png') }}" class="rounded-circle" width="50" height="50" alt="">
                                                </td>
                                                <td>Member</td>
                                                <td>
                                                    <div class="btn-group" role="group">
                                                        <a class="btn btn-warning" href="{{ route('admin.user.edit', $user->user_id) }}">Edit</a>
                                                        <a class="btn btn-info" href="{{ route('admin.user.grant.privileges', $user->user_id) }}">Grant privileges</a>
                                                        <a class="btn btn-danger" href="#" onclick="deleteUser()">Remove</a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <script>
                                                function deleteUser() {
                                                    Swal.fire({
                                                        title: "Are you sure?",
                                                        text: "You won't be able to revert this!",
                                                        icon: "warning",
                                                        showCancelButton: true,
                                                        confirmButtonColor: "#3085d6",
                                                        cancelButtonColor: "#d33",
                                                        confirmButtonText: "Yes, delete it!"
                                                    }).then((result) => {
                                                        if (result.isConfirmed) {
                                                            window.location = "{{ route('admin.user.delete', $user->user_id) }}";
                                                            // Swal.fire({
                                                            //     title: "Deleted!",
                                                            //     text: "Your file has been deleted.",
                                                            //     icon: "success"
                                                            // });
                                                        }
                                                    });
                                                }
                                            </script>
                                        @endforeach
                                    @endisset
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection