@extends('backend.layouts.admin')

@section('title', 'List des entités sources')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">Liste des ministères</h3>
                </div>
            </div>
            <div class="row">
                <div class="text-center">
                    <a class="btn btn-light" href="{{ route('minister.create') }}"><i class="fa fa-plus-circle">&nbsp;Ajouter un ministère</i></a>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">#</th>
                                    <th scope="col">Nom</th>
                                    <th scope="col">Logo</th>
                                    <th scope="col">E-mail</th>
                                    <th scope="col">Téléphone</th>
                                    <th scope="col">Localisation</th>
                                    <th scope="col">Site web</th>
                                    <th scope="col">Mission</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @isset($ministers)
                                    @foreach ($ministers as $i => $minister)
                                        <tr>
                                            <th scope="row">{{ ($i+1) }}</th>
                                            <td>{{ $minister->nom }}</td>
                                            @if ($minister->logo)
                                                <td><img src="{{asset('assets/ministers/'.$minister->logo)}}" height="50" width="50"
                                                        style="object-fit: cover" alt="{{ $minister->name }}"></td>
                                            @endif
                                            <td>{{ $minister->email }}</td>
                                            <td>{{ $minister->telephone }}</td>
                                            <td>{{ $minister->localisation }}</td>
                                            <td>{{ $minister->site_web }}</td>
                                            <td>{{ $minister->mission }}</td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a class="btn btn-warning" href="{{ route('minister.edit', $minister) }}">Modifier</a>
                                                    <a class="btn btn-danger" href="#" onclick="deleteMinister({{ $minister->id_ministere }})">Supprimer</a>
                                                </div>
                                            </td>
                                        </tr>
                                        <script>
                                            function deleteMinister(minister) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('minister.delete', ':minister') }}".replace(':minister', minister);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endisset
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        {{ $ministers->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection