@extends('backend.layouts.admin')

@section('title', 'Add Role')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="{{ route('dashboard') }}" class="">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Modification du ministère</h5>
                    </div>
                    <form action="{{ route('minister.update', $minister) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <!-- Minister Name -->
                        <div class="form-floating mb-3">
                            <input type="text" name="nom" value="{{$minister->nom}}" class="form-control @error('nom') is-invalid @enderror" id="floatingText" placeholder="Nom du ministère...">
                            <label for="floatingText">Nom du minitère</label>
                            @error('nom')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>

                         <!-- Minister Name -->
                         <div class="form-floating mb-3">
                            <input type="email" name="email" value="{{$minister->email}}" class="form-control @error('email') is-invalid @enderror" id="floatingText" placeholder="E-mail du ministère...">
                            <label for="floatingText">E-mail du ministère</label>
                            @error('email')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                         <!-- Minister Phone -->
                         <div class="form-floating mb-3">
                            <input type="text" name="telephone" value="{{$minister->telephone}}" class="form-control @error('telephone') is-invalid @enderror" id="floatingText" placeholder="Téléphone du ministère...">
                            <label for="floatingText">Téléphone du ministère</label>
                            @error('telephone')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                         <!-- Minister Location -->
                         <div class="form-floating mb-3">
                            <input type="text" name="localisation" value="{{$minister->localisation}}" class="form-control @error('localisation') is-invalid @enderror" id="floatingText" placeholder="Localisation du ministère...">
                            <label for="floatingText">Localisation du ministère</label>
                            @error('telephone')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                         <!-- Minister website -->
                         <div class="form-floating mb-3">
                            <input type="text" name="site_web" value="{{ $minister->site_web }}" class="form-control @error('site_web') is-invalid @enderror" id="floatingText" placeholder="Site web du ministère...">
                            <label for="floatingText">Site web du ministère</label>
                            @error('site_web')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                         <!-- Minister Logo -->
                         <div class="form-floating mb-3">
                            <input type="file" name="logo" value="{{ $minister->logo }}" class="form-control @error('logo') is-invalid @enderror" id="floatingText" placeholder="Logo du ministère...">
                            <label for="floatingText">Logo du ministère</label>
                            @error('logo')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <!-- Minister mission -->
                        <div class="form-floating mb-3">
                            <input type="text" name="mission" value="{{ $minister->mission }}" class="form-control @error('mission') is-invalid @enderror" id="floatingText" placeholder="Mission du ministère...">
                            <label for="floatingText">Mission du ministère</label>
                            @error('mission')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Modifier le  ministère</button>
                        </div>
                        <div class="text-center">
                            <a class="text-white text-decoration-underline" href="{{ route('minister.index') }}">Retour à la liste des ministères</a>                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection