@extends('backend.layouts.admin')

@section('title', 'Liste des Types de Document')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">Liste des Types de Document</h3>
                </div>
            </div>
            <div class="row">
                <div class="text-center">
                    <a class="btn btn-light" href="{{ route('admin.file.type.add') }}"><i class="fa fa-plus-circle">&nbsp;Ajout Type Document</i></a>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">#</th>
                                    <th scope="col">Nom Type Document</th>
                                    <th scope="col">Description</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @isset($fileTypes)
                                    @foreach ($fileTypes as $i => $fileType)
                                        <tr>
                                            <th scope="row">{{ ($i+1) }}</th>
                                            <td>{{ $fileType->file_type_name }}</td>
                                            <td>{!! $fileType->description !!}</td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a class="btn btn-warning" href="{{ route('admin.file.type.edit', $fileType->file_type_id) }}">Modifier</a>
                                                    <a class="btn btn-danger" href="#" onclick="removeFileType({{ $fileType->file_type_id }})">Suppirmer</a>
                                                </div>
                                            </td>
                                        </tr>
                                        <script>
                                            function removeFileType(fileType) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!",
                                                    cancelButtonText: "Annuler"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('admin.file.type.delete', ':fileType') }}".replace(':fileType', fileType);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endisset
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection