@extends('backend.layouts.admin')

@section('title', 'Modification Type de Document')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="{{ route('dashboard') }}" class="">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Modification Type Document</h5>
                    </div>
                    <form action="{{ route('admin.file.type.update', $fileType->file_type_id) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <!-- File Type Name -->
                        <div class="form-floating mb-3">
                            <input type="text" name="file_type_name" value="{{ old('file_type_name') ?? $fileType->file_type_name }}" class="form-control @error('file_type_name') is-invalid @enderror" id="floatingText" placeholder="File Type Name">
                            <label for="floatingText">Nom Type Fichier :</label>
                            @error('file_type_name')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <!-- Description -->
                        <div class="mb-3">
                            <textarea name="description" id="ckeditor" cols="30" rows="2" class="form-control" placeholder="Description :">{{ old('description') ?: $fileType->description  }}</textarea>
                            @error('description')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Modifier le type de fichier</button>
                        </div>
                        <div class="text-center">
                            <a class="text-white text-decoration-underline" href="{{ route('admin.file.type.list') }}">Retour à la liste des types de fichier</a>                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection