@extends('backend.layouts.admin')

@section('title', 'Edit Role')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="index.html" class="">
                            <h3 class="text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h3>Edit Role</h3>
                    </div>
                    <form action="{{ route('admin.role.update', $role->id) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <div class="row">
                            <!-- Role Name -->
                            <div class="col-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="role_name" value="{{ old('role_name') ?? $role->name }}" class="form-control @error('role_name') is-invalid @enderror" id="floatingText" placeholder="Role Name">
                                    <label for="floatingText">Role Name</label>
                                    @error('role_name')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-6">
                                <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-check me-2"></i>Update</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection