@extends('backend.layouts.admin')

@section('title', 'Add Role')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="{{ route('dashboard') }}" class="">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Ajout Entité</h5>
                    </div>
                    <form action="{{ route('admin.entity.store') }}" method="POST">
                        @csrf
                        <!-- Entity Name -->
                        <div class="form-floating mb-3">
                            <input type="text" name="entity_name" value="{{ old('entity_name') }}" class="form-control @error('entity_name') is-invalid @enderror" id="floatingText" placeholder="Entity Name">
                            <label for="floatingText">Nom de l'entité</label>
                            @error('entity_name')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <!-- Entity Type -->
                        <div class="mb-3">
                            <select name="entity_type" class="form-select @error('entity_type') is-invalid @enderror" style="height:58px;line-height:1.25;">
                                <option value="">Type Entité</option>
                                @foreach ($entityTypes as $entityType)
                                    <option {{ old('entity_type') == $entityType->entity_type_id ? 'selected' : '' }} value="{{ $entityType->entity_type_id }}">{{ $entityType->entity_type_name }}</option>
                                @endforeach
                            </select>
                            @error('entity_type')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Ajouter l'entité</button>
                        </div>
                        <div class="text-center">
                            <a class="text-white text-decoration-underline" href="{{ route('admin.entity.list') }}">Retour à la liste des entités</a>                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection