@extends('backend.layouts.admin')

@section('title', 'List des entités sources')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">Liste des directions</h3>
                </div>
            </div>
            <div class="row">
                <div class="text-center">
                    <a class="btn btn-light" href="{{ route('direction.create') }}"><i class="fa fa-plus-circle">&nbsp;Ajouter une direction</i></a>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">#</th>
                                    <th scope="col">Ministère</th>
                                    <th scope="col">Nom</th>
                                    <th scope="col">Logo</th>
                                    <th scope="col">E-mail</th>
                                    <th scope="col">Téléphone</th>
                                    <th scope="col">Localisation</th>
                                    <th scope="col">Site web</th>
                                    <th scope="col">Mission</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @isset($directions)
                                    @foreach ($directions as $i => $direction)
                                        <tr>
                                            <th scope="row">{{ ($i+1) }}</th>
                                            <td>{{ $direction->ministere->nom }}</td>
                                            <td>{{ $direction->nom }}</td>
                                            @if ($direction->logo)
                                                <td><img src="{{asset('assets/directions/'.$direction->logo)}}" height="50" width="50"
                                                        style="object-fit: cover" alt="{{ $direction->name }}"></td>
                                            @endif
                                            <td>{{ $direction->email }}</td>
                                            <td>{{ $direction->telephone }}</td>
                                            <td>{{ $direction->localisation }}</td>
                                            <td>{{ $direction->site_web }}</td>
                                            <td>{{ $direction->mission }}</td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a class="btn btn-warning" href="{{ route('direction.edit', $direction) }}">Modifier</a>
                                                    <a class="btn btn-danger" href="#" onclick="deleteMinister({{ $direction->id_direction }})">Supprimer</a>
                                                </div>
                                            </td>
                                        </tr>
                                        <script>
                                            function deleteMinister(direction) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('direction.delete', ':direction') }}".replace(':direction', direction);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endisset
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        {{ $directions->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection