@extends('backend.layouts.admin')

@section('title', 'Add Role')

@section('content')
    <div class="container-fluid">
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="{{ route('dashboard') }}" class="">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Ajout de la direction</h5>
                    </div>
                    <form action="{{ route('direction.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <!-- Entity Type -->
                        <div class="mb-3">
                            <select name="id_ministere" class="form-select @error('id_ministere') is-invalid @enderror" style="height:58px;line-height:1.25;">
                                <option value="">--Choisissez le ministère--</option>
                                @foreach ($ministeres as $ministere)
                                    <option {{ old('id_ministere') == $ministere->id_ministere ? 'selected' : '' }} value="{{ $ministere->id_ministere }}">{{ $ministere->nom }}</option>
                                @endforeach
                            </select>
                            @error('id_ministere')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <!-- Minister Name -->
                        <div class="form-floating mb-3">
                            <input type="text" name="nom" value="{{ old('nom') }}" class="form-control @error('nom') is-invalid @enderror" id="floatingText" placeholder="Nom de la direction...">
                            <label for="floatingText">Nom de la direction</label>
                            @error('nom')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>

                         <!-- Minister Name -->
                         <div class="form-floating mb-3">
                            <input type="email" name="email" value="{{ old('email') }}" class="form-control @error('email') is-invalid @enderror" id="floatingText" placeholder="E-mail de la direction...">
                            <label for="floatingText">E-mail de la direction</label>
                            @error('email')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                         <!-- Minister Phone -->
                         <div class="form-floating mb-3">
                            <input type="text" name="telephone" value="{{ old('telephone') }}" class="form-control @error('telephone') is-invalid @enderror" id="floatingText" placeholder="Téléphone de la direction...">
                            <label for="floatingText">Téléphone de la direction</label>
                            @error('telephone')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                         <!-- Minister Location -->
                         <div class="form-floating mb-3">
                            <input type="text" name="localisation" value="{{ old('localisation') }}" class="form-control @error('localisation') is-invalid @enderror" id="floatingText" placeholder="Localisation de la direction...">
                            <label for="floatingText">Localisation de la direction</label>
                            @error('telephone')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                         <!-- Minister website -->
                         <div class="form-floating mb-3">
                            <input type="text" name="site_web" value="{{ old('site_web') }}" class="form-control @error('site_web') is-invalid @enderror" id="floatingText" placeholder="Site web de la direction...">
                            <label for="floatingText">Site web de la direction</label>
                            @error('site_web')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                         <!-- Minister Logo -->
                         <div class="form-floating mb-3">
                            <input type="file" name="logo" value="{{ old('logo') }}" class="form-control @error('logo') is-invalid @enderror" id="floatingText" placeholder="Logo de la direction...">
                            <label for="floatingText">Logo de la direction</label>
                            @error('logo')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <!-- Minister mission -->
                        <div class="form-floating mb-3">
                            <input type="text" name="mission" value="{{ old('mission') }}" class="form-control @error('mission') is-invalid @enderror" id="floatingText" placeholder="Mission de la direction...">
                            <label for="floatingText">Mission de la direction</label>
                            @error('mission')
                                <span class="invalid-feedback">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Ajouter la direction</button>
                        </div>
                        <div class="text-center">
                            <a class="text-white text-decoration-underline" href="{{ route('direction.index') }}">Retour à la liste des desctions</a>                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection