@extends('backend.layouts.admin')

@section('title', 'Renvoi da la demande en modification')

@section('content')
<div class="container-fluid">
    <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
        <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
            <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                <div class="d-flex align-items-center justify-content-between mb-3">
                    <a href="index.html">
                        <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                    </a>
                    <h5>Renvoi en modification</h5>
                </div>
                <form action="{{ route('dashboard.demande.validate.return', $demande->id_demande) }}" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    <!-- Attachment -->
                    <div class="mb-3">
                        <input type="file" name="attachments[]" hidden multiple
                            id="real-file" />
                        <button type="button" id="custom-button"
                            class="bg-white w-100 text-start @error('attachments') is-invalid @enderror"
                            style="height:calc(3.6rem);line-height:1.25;border-radius: 5px; padding: 0 15px; border: 1px solid #ddd;"
                            title="Rassurer vous d'avoir fusionner tous les documents en un seul fichier .pdf">
                            Cliquer pour joindre un document : *
                        </button>
                        <div>
                            <span id="file-name" class="text-success fw-bold"></span>
                        </div>
                        @error('attachments')
                        <span class="invalid-feedback">
                            {{ $message }}
                        </span>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <input type="hidden" name="demande" value="{{ $demande->id_demande }}">
                        <textarea class="form-control" name="motif" id="ckeditor" rows="10" cols="30"
                            placeholder="Donnez le motif du rejet"></textarea>
                    </div>
                    <div class="mb-3">
                        <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Renvoyer</button>
                    </div>
                    <div class="mb-3 text-center">
                        <a class="text-white text-decoration-underline" href="{{ route('dashboard.demande.list') }}">Retour à la liste des demandes</a>                            
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection