@extends('backend.layouts.admin')

@section('title', 'Traitement de la demande')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="col-12">
            <div class="text-center">
                <h3 class="bg-primary rounded p-3 mb-4">Traitement de la demande</h3>
            </div>
        </div>
        <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
            <div class="col-12 col-sm-8 col-md-6 col-lg-6 col-xl-6">
                <div class="bg-secondary rounded p-4 p-sm-5 my-4 mx-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <a href="{{ route('dashboard') }}" class="">
                            <h3 class="fs-5 text-primary"><i class="fa fa-user-edit me-2"></i>{{ config('app.name') }}</h3>
                        </a>
                        <h5>Traitement de la demande</h5>
                    </div>
                    <form action="{{ route('dashboard.demande.process.validate', $demande->id_demande) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <!-- Company Name -->
                            <div class="mb-3">
                                <div class="form-floating mb-3">
                                    <input type="text" name="" value="{{ $demande->promoteur->nom_entreprise }}" class="form-control" disabled>
                                    <label for="floatingText">Entreprise: *</label>
                                </div>
                            </div>
                            <!-- Attachment -->
                            <div class="col-sm-12 col-md-12 col-lg-12">
                                <div class="mb-3">
                                    <input type="file" name="attachments[]" hidden multiple id="real-file" />
                                    <button type="button" id="custom-button" class="bg-white w-100 text-start @error('attachments') is-invalid @enderror" style="height:calc(3.6rem);line-height:1.25;border-radius: 5px; padding: 0 15px; border: 1px solid #ddd;" title="Rassurer vous d'avoir fusionner tous les documents en un seul fichier .pdf">
                                        Cliquer pour joindre le(s) document(s) : *
                                    </button>
                                    <div>
                                        <span id="file-name" class="text-success fw-bold"></span>
                                    </div>
                                    @error('attachments')
                                        <span class="invalid-feedback">
                                            {{ $message }}
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- Observation -->
                            <div class="mb-3">
                                <textarea name="observation" id="ckeditor" cols="30" rows="2" class="form-control" placeholder="Observation :">{{ old('observation') }}</textarea>
                                @error('observation')
                                    <span class="invalid-feedback">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <button type="submit" class="btn btn-primary py-3 w-100 mb-4"><i class="fa fa-save me-2"></i>Valider le Traitement</button>
                        </div>
                        <div class="text-center">
                            <a class="text-white text-decoration-underline" href="{{ route('dashboard.demande.list') }}">Retour à la liste des demandes</a>                            
                        </div>
                    </form> 
                </div>
            </div>
        </div>
    </div>
@endsection