@extends('backend.layouts.admin')

@section('title', 'Liste des demandes')

@section('content')
<div class="container-fluid pt-4 px-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="text-center">
                <h3 class="bg-primary rounded p-3 mb-4">Liste des Demandes</h3>
            </div>
        </div>
        <div class="col-12">
            <div class="bg-secondary rounded h-100 p-4">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th>N°</th>
                                <th>Demandeur</th>
                                <th>Titre</th>
                                <th>Type Document</th>
                                <th>Fichier Joint</th>
                                <th>Commentaire</th>
                                <th>Date Envoi</th>
                                <th>Staut Demande</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if (isset($demandes) && $demandes->count() > 0)
                            @foreach ($demandes as $key => $demande)
                            <tr>
                                <td>{{ ($key + 1) }}</td>
                                <td>{{ $demande->promoteur->nom_entreprise }}</td>
                                <td>{{ $demande->titre_demande }}</td>
                                <td>{{ $demande->typeDocument->libelle }}</td>
                                <td>
                                    @php $attachments = $demande->documents_joints; @endphp
                                    @foreach ($attachments as $attachment)
                                    <div class="mb-3">
                                        <a target="_blank" href="{{ url('storage/documents_recus/'.$attachment) }}"
                                            title="Cliquer pour visualier ou télécharger">
                                            {{ $attachment }}<br />
                                        </a>
                                    </div>
                                    @endforeach
                                </td>
                                <td>{!! $demande->commentaire !!}</td>
                                <td>{{ Utilities::formatDate($demande->date_demande) }}</td>
                                @php
                                $color = '';
                                if ($demande->id_statut_demande == 2){
                                $color = '#f2b707';
                                }
                                if ($demande->id_statut_demande == 3){
                                $color = '#0cc0e4';
                                }
                                if ($demande->id_statut_demande == 4){
                                $color = '#ffffff';
                                }
                                if ($demande->id_statut_demande == 5){
                                $color = '#dc3545';
                                }
                                if ($demande->id_statut_demande == 6){
                                $color = '#188050';
                                }
                                @endphp
                                <td class="fw-bold" style="color: {{ $color ?? '#5c678d' }}">
                                    {{ $demande->statutDemande->libelle }}
                                </td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        @hasrole('ministre')
                                        @if ($demande->id_statut_demande == 1)
                                        <a class="btn btn-warning" href="#"
                                            onclick="orientDemande({{ $demande->id_demande }})">Orienter</a>
                                        <a class="btn btn-danger" href="#" data-bs-toggle="modal"
                                            data-bs-target="#modalReject-{{ $demande->id_demande }}">Rejeter</a>
                                        @endif
                                        @endhasrole
                                        @hasanyrole(Admin::getDirectionRoles())
                                        @if ($demande->id_statut_demande == 2)
                                        <a class="btn btn-warning" href="#"
                                            onclick="orientDemande({{ $demande->id_demande }})">Orienter</a>
                                        @endif
                                        @endhasanyrole
                                        @hasanyrole(Admin::getServiceRoles())
                                        @if ($demande->id_statut_demande == 3)
                                        {{-- <a class="btn btn-warning"
                                            href="{{ route('dashboard.demande.show', $demande->id_demande) }}"
                                            title="Cliquer pour voir les détails"><i class="fa fa-eye"
                                                aria-hidden="true"></i></a> --}}
                                        <a class="btn btn-info"
                                            href="{{ route('dashboard.demande.process', $demande->id_demande) }}">Traiter</a>
                                        <a class="btn btn-warning"
                                            href="{{ route('dashboard.demande.return', $demande->id_demande) }}">Renvoyer</a>
                                        {{-- <a class="btn btn-warning" href="#" data-bs-toggle="modal"
                                            data-bs-target="#modalReturn-{{ $demande->id_demande }}">Renvoyer</a> --}}
                                        @endif
                                        @endhasanyrole
                                    </div>
                                </td>
                            </tr>
                            <script>
                                function orientDemande(demande) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr de vouloir orienter cette demande ?",
                                                    // text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, orienter!",
                                                    cancelButtonText: "Annuler"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('dashboard.demande.orient', ':demande') }}".replace(':demande', demande);
                                                    }
                                                });
                                            }

                                            function returnDemande(demande) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr de vouloir retourner cette demande ?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, orienter!",
                                                    cancelButtonText: "Annuler"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('dashboard.demande.return', ':demande') }}".replace(':demande', demande);
                                                    }
                                                });
                                            }
                            </script>
                            <!-- Modal -->
                            <!-- Orient -->
                            {{-- <div class="modal fade" id="modalOrient" data-bs-backdrop="static"
                                data-bs-keyboard="false" tabindex="-1" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="bg-secondary modal-content">
                                        <div class="modal-header">
                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Orienter la demande
                                            </h1>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <form id="orient-form"
                                            action="{{ route('dashboard.demande.orient', $demande->id_demande) }}"
                                            method="POST">
                                            @csrf
                                            <div class="bg-secondary modal-body">
                                                <input type="hidden" name="demande" value="{{ $demande->id_demande }}">
                                                <select class="form-select" name="direction" id="" required
                                                    style="height: 58px;">
                                                    <option value="">Sélection la direction</option>
                                                    @if (isset($directions))
                                                    @foreach ($directions as $direction)
                                                    <option {{ old('direction')==$direction->id_direction ? 'selected' :
                                                        '' }} value="{{ $direction->id_direction }}">{{ $direction->nom
                                                        }}</option>
                                                    @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">Quitter</button>
                                                <button type="submit" class="btn btn-primary">Orienter</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div> --}}
                            <!-- Reject -->
                            <div class="modal fade" id="modalReject-{{ $demande->id_demande }}" data-bs-keyboard="false"
                                tabindex="-1" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="bg-secondary modal-content">
                                        <div class="modal-header">
                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Rejeter la demande
                                            </h1>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <form id="reject-form-{{ $demande->id_demande }}"
                                            action="{{ route('dashboard.demande.reject', $demande->id_demande) }}"
                                            method="POST">
                                            @csrf
                                            <div class="bg-secondary modal-body">
                                                <input type="hidden" name="demande" value="{{ $demande->id_demande }}">
                                                <textarea class="form-control" name="motif" id="motif_rejet" rows="10"
                                                    cols="30" required
                                                    placeholder="Donnez le motif du rejet"></textarea>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">Quitter</button>
                                                <button type="submit" class="btn btn-primary">Rejeter</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <!-- Return -->
                            {{-- <div class="modal fade" id="modalReturn-{{ $demande->id_demande }}"
                                data-bs-keyboard="false" tabindex="-1" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="bg-secondary modal-content">
                                        <div class="modal-header">
                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Renvoi pour complément
                                                d'information</h1>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <form id="return-form-{{ $demande->id_demande }}"
                                            action="{{ route('dashboard.demande.return', $demande->id_demande) }}"
                                            method="POST" enctype="multipart/form-data">
                                            @csrf
                                            <div class="bg-secondary modal-body">
                                                <!-- Attachment -->
                                                <div class="mb-3">
                                                    <input type="file" name="attachments[]" hidden multiple
                                                        id="real-file-{{ $demande->id_demande }}" />
                                                    <button type="button" id="custom-button"
                                                        class="bg-white w-100 text-start @error('attachments') is-invalid @enderror"
                                                        style="height:calc(3.6rem);line-height:1.25;border-radius: 5px; padding: 0 15px; border: 1px solid #ddd;"
                                                        title="Rassurer vous d'avoir fusionner tous les documents en un seul fichier .pdf">
                                                        Cliquer pour joindre un document : *
                                                    </button>
                                                    <div>
                                                        <span id="file-name-{{ $demande->id_demande }}"
                                                            class="text-success fw-bold"></span>
                                                    </div>
                                                    @error('attachments')
                                                    <span class="invalid-feedback">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>
                                                <div class="mb-3">
                                                    <input type="hidden" name="demande"
                                                        value="{{ $demande->id_demande }}">
                                                    <textarea class="form-control" name="motif" id="ckeditor" rows="10"
                                                        cols="30" placeholder="Donnez le motif du rejet"></textarea>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">Quitter</button>
                                                <button type="submit" class="btn btn-primary">Renvoyer</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div> --}}
                            <!-- ./Fin Modal -->
                            @endforeach
                            @else
                            <tr class="text-center">
                                <td colspan="11" class="fw-bold">Aucune donnée n'est disponible.</td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection