@extends('backend.layouts.admin')

@section('title', 'Détails de la demande')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">Liste des Demandes</h3>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>N°</th>
                                    <th>Entreprise</th>
                                    <th>Titre</th>
                                    <th colspan="3" class="text-center">Fichier Joint</th>
                                </tr>
                            </thead>
                            <tbody>
                                @isset($demande)
                                    <tr>
                                        <td>{{ $demande->id_demande }}</td>
                                        <td>{{ $demande->promoteur->nom_entreprise }}</td>
                                        <td>{{ $demande->titre_demande }}</td>
                                        @foreach ($demande->documents_joints as $key => $attachment)
                                            <td >
                                                <div class="btn text-white">{{ $attachment }}</div>
                                                <div class="btn-group" role="group">
                                                    @hasanyrole(Admin::getDirectionRoles())
                                                        @if ($demande->id_statut_demande == 3)
                                                            <a class="btn btn-info" target="_blank" href="{{ url('storage/documents_recus/'.$attachment) }}" title="Cliquer pour visualier ou télécharger">
                                                                Visualiser
                                                            </a>
                                                            <a class="btn btn-warning" href="#" onclick="returnDemande({{ $demande->id_demande }}, {{ $key }})">Renvoyer</a>
                                                        @endif
                                                    @endhasanyrole
                                                </div>
                                            </td>
                                        @endforeach

                                    </tr>
                                    <script>
                                        function returnDemande(demande, file) {
                                            Swal.fire({
                                                title: "Êtes-vous sûr de vouloir retourner cette demande ?",
                                                text: "Vous ne pourrez pas revenir en arrière!",
                                                icon: "warning",
                                                showCancelButton: true,
                                                confirmButtonColor: "#3085d6",
                                                cancelButtonColor: "#d33",
                                                confirmButtonText: "Oui, orienter!",
                                                cancelButtonText: "Annuler"
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    window.location = "{{ route('dashboard.demande.return', [':demande', ':file']) }}".replace(':demande', demande).replace(':file', file);
                                                }
                                            });
                                        }
                                    </script>
                                    <!-- Reject -->
                                    <div class="modal fade" id="modalReject-{{ $demande->id_demande }}" data-bs-keyboard="false" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="bg-secondary modal-content">
                                                <div class="modal-header">
                                                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Rejeter la demande</h1>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form id="reject-form-{{ $demande->id_demande }}" action="{{ route('dashboard.demande.reject', $demande->id_demande) }}" method="POST">
                                                    @csrf
                                                    <div class="bg-secondary modal-body">
                                                        <input type="hidden" name="demande" value="{{ $demande->id_demande }}">
                                                        <textarea class="form-control" name="motif" id="motif_rejet" rows="10" cols="30" required placeholder="Donnez le motif du rejet"></textarea>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Quitter</button>
                                                        <button type="submit" class="btn btn-primary">Rejeter</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- ./Fin Modal -->
                                @else
                                    <tr class="text-center">
                                        <td colspan="11" class="fw-bold">Aucune donnée n'est disponible.</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection